/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.datagen.recipe.PneumaticCraftRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class HeatPropertiesRecipeBuilder
extends PneumaticCraftRecipeBuilder<HeatPropertiesRecipeBuilder> {
    private final Block block;
    private final int temperature;
    private final double thermalResistance;
    private final Map<String, String> predicates;
    private final int heatCapacity;
    private final BlockState transformHot;
    private final BlockState transformCold;
    private final BlockState transformHotFlowing;
    private final BlockState transformColdFlowing;

    public HeatPropertiesRecipeBuilder(Block block, int temperature, double thermalResistance, Map<String, String> predicates) {
        this(block, temperature, thermalResistance, predicates, 0, null, null, null, null);
    }

    public HeatPropertiesRecipeBuilder(Block block, int temperature, double thermalResistance, Map<String, String> predicates, int heatCapacity, BlockState transformHot, BlockState transformCold, BlockState transformHotFlowing, BlockState transformColdFlowing) {
        super(PneumaticRegistry.RL("heat_properties"));
        this.block = block;
        this.temperature = temperature;
        this.thermalResistance = thermalResistance;
        this.predicates = predicates;
        this.heatCapacity = heatCapacity;
        this.transformHot = transformHot;
        this.transformCold = transformCold;
        this.transformHotFlowing = transformHotFlowing;
        this.transformColdFlowing = transformColdFlowing;
    }

    @Override
    protected PneumaticCraftRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new HeatPropertiesRecipeResult(id);
    }

    public class HeatPropertiesRecipeResult
    extends PneumaticCraftRecipeBuilder.RecipeResult {
        HeatPropertiesRecipeResult(ResourceLocation id) {
            super(HeatPropertiesRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("block", PneumaticCraftUtils.getRegistryName(HeatPropertiesRecipeBuilder.this.block).orElseThrow().toString());
            json.addProperty("temperature", (Number)HeatPropertiesRecipeBuilder.this.temperature);
            json.addProperty("thermalResistance", (Number)HeatPropertiesRecipeBuilder.this.thermalResistance);
            if (!HeatPropertiesRecipeBuilder.this.predicates.isEmpty()) {
                JsonObject obj = new JsonObject();
                HeatPropertiesRecipeBuilder.this.predicates.forEach((arg_0, arg_1) -> ((JsonObject)obj).addProperty(arg_0, arg_1));
                json.add("statePredicate", (JsonElement)obj);
            }
            if (HeatPropertiesRecipeBuilder.this.heatCapacity > 0) {
                json.addProperty("heatCapacity", (Number)HeatPropertiesRecipeBuilder.this.heatCapacity);
            }
            this.maybeAddBlockstateProp(json, "transformHot", HeatPropertiesRecipeBuilder.this.transformHot);
            this.maybeAddBlockstateProp(json, "transformCold", HeatPropertiesRecipeBuilder.this.transformCold);
            this.maybeAddBlockstateProp(json, "transformHotFlowing", HeatPropertiesRecipeBuilder.this.transformHotFlowing);
            this.maybeAddBlockstateProp(json, "transformColdFlowing", HeatPropertiesRecipeBuilder.this.transformColdFlowing);
        }

        private void maybeAddBlockstateProp(JsonObject json, String key, BlockState state) {
            if (state != null) {
                JsonObject obj = new JsonObject();
                Block block = state.m_60734_();
                if (block instanceof LiquidBlock) {
                    LiquidBlock liq = (LiquidBlock)block;
                    obj.addProperty("fluid", PneumaticCraftUtils.getRegistryName((Fluid)liq.getFluid()).orElseThrow().toString());
                } else {
                    obj.addProperty("block", state.toString());
                }
                json.add(key, (JsonElement)obj);
            }
        }
    }
}

