/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.apache.commons.lang3.Validate;

public class AssemblyRecipeImpl
extends AssemblyRecipe {
    private final Ingredient input;
    private final ItemStack output;
    private final AssemblyRecipe.AssemblyProgramType program;

    public AssemblyRecipeImpl(ResourceLocation id, @Nonnull Ingredient input, @Nonnull ItemStack output, AssemblyRecipe.AssemblyProgramType program) {
        super(id);
        this.input = input;
        this.output = output;
        this.program = program;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getInputAmount() {
        return this.input.m_43908_().length > 0 ? this.input.m_43908_()[0].m_41613_() : 0;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public AssemblyRecipe.AssemblyProgramType getProgramType() {
        return this.program;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack) && stack.m_41613_() >= this.getInputAmount();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        buffer.m_130055_(this.output);
        buffer.m_130130_(this.program.ordinal());
    }

    public RecipeSerializer<?> m_7707_() {
        return switch (this.getProgramType()) {
            case AssemblyRecipe.AssemblyProgramType.LASER -> (RecipeSerializer)ModRecipeSerializers.ASSEMBLY_LASER.get();
            case AssemblyRecipe.AssemblyProgramType.DRILL -> (RecipeSerializer)ModRecipeSerializers.ASSEMBLY_DRILL.get();
            default -> throw new IllegalStateException("invalid program type: " + String.valueOf((Object)this.getProgramType()));
        };
    }

    public RecipeType<?> m_6671_() {
        return switch (this.getProgramType()) {
            default -> throw new IncompatibleClassChangeError();
            case AssemblyRecipe.AssemblyProgramType.DRILL -> (PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_DRILL.get();
            case AssemblyRecipe.AssemblyProgramType.LASER -> (PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_LASER.get();
            case AssemblyRecipe.AssemblyProgramType.DRILL_LASER -> (PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_DRILL_LASER.get();
        };
    }

    public static Map<ResourceLocation, AssemblyRecipe> calculateAssemblyChain(Collection<AssemblyRecipe> drillRecipes, Collection<AssemblyRecipe> laserRecipes) {
        HashMap<ResourceLocation, AssemblyRecipe> drillLaser = new HashMap<ResourceLocation, AssemblyRecipe>();
        for (AssemblyRecipe r1 : drillRecipes) {
            for (AssemblyRecipe r2 : laserRecipes) {
                if (!r2.getInput().test(r1.getOutput()) || r1.getOutput().m_41613_() % r2.getInputAmount() != 0 || r2.getOutput().m_41741_() < r2.getOutput().m_41613_() * (r1.getOutput().m_41613_() / r2.getInputAmount())) continue;
                ItemStack output = r2.getOutput().m_41777_();
                output.m_41764_(output.m_41613_() * (r1.getOutput().m_41613_() / r2.getInputAmount()));
                ResourceLocation id = PneumaticRegistry.RL(r1.m_6423_().m_135815_() + "_" + r2.m_6423_().m_135815_());
                drillLaser.put(id, new AssemblyRecipeImpl(id, r1.getInput(), output, AssemblyRecipe.AssemblyProgramType.DRILL_LASER));
            }
        }
        return drillLaser;
    }

    public static class Serializer<T extends AssemblyRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            String program = GsonHelper.m_13906_((JsonObject)json, (String)"program").toUpperCase(Locale.ROOT);
            try {
                AssemblyRecipe.AssemblyProgramType programType = AssemblyRecipe.AssemblyProgramType.valueOf(program);
                Validate.isTrue((programType != AssemblyRecipe.AssemblyProgramType.DRILL_LASER ? 1 : 0) != 0, (String)"'drill_laser' may not be used in recipe JSON!", (Object[])new Object[0]);
                return this.factory.create(recipeId, input, result, programType);
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(e.getMessage());
            }
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack out = buffer.m_130267_();
            AssemblyRecipe.AssemblyProgramType program = AssemblyRecipe.AssemblyProgramType.values()[buffer.m_130242_()];
            return this.factory.create(recipeId, input, out, program);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends AssemblyRecipe> {
            public T create(ResourceLocation var1, @Nonnull Ingredient var2, @Nonnull ItemStack var3, AssemblyRecipe.AssemblyProgramType var4);
        }
    }
}

