/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.RedstoneModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncRedstoneModuleToServer
extends LocationIntPacket {
    private final Direction side;
    private final byte op;
    private final byte ourColor;
    private final byte otherColor;
    private final int constantVal;
    private final boolean invert;
    private final boolean input;
    private final boolean comparatorInput;

    public PacketSyncRedstoneModuleToServer(RedstoneModule module) {
        super(module.getTube().m_58899_());
        this.input = module.getRedstoneDirection() == RedstoneModule.EnumRedstoneDirection.INPUT;
        this.side = module.getDirection();
        this.op = (byte)module.getOperation().ordinal();
        this.ourColor = (byte)module.getColorChannel();
        this.otherColor = (byte)module.getOtherColor();
        this.constantVal = module.getConstantVal();
        this.invert = module.isInverted();
        this.comparatorInput = module.isComparatorInput();
    }

    PacketSyncRedstoneModuleToServer(FriendlyByteBuf buffer) {
        super(buffer);
        this.side = (Direction)buffer.m_130066_(Direction.class);
        this.input = buffer.readBoolean();
        this.ourColor = buffer.readByte();
        if (this.input) {
            this.op = 0;
            this.otherColor = 0;
            this.constantVal = 0;
            this.invert = false;
            this.comparatorInput = buffer.readBoolean();
        } else {
            this.op = buffer.readByte();
            this.otherColor = buffer.readByte();
            this.constantVal = buffer.m_130242_();
            this.invert = buffer.readBoolean();
            this.comparatorInput = false;
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.m_130068_((Enum)this.side);
        buf.writeBoolean(this.input);
        buf.writeByte((int)this.ourColor);
        if (this.input) {
            buf.writeBoolean(this.comparatorInput);
        } else {
            buf.writeByte((int)this.op);
            buf.writeByte((int)this.otherColor);
            buf.m_130130_(this.constantVal);
            buf.writeBoolean(this.invert);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (PneumaticCraftUtils.canPlayerReach((Player)player, this.pos)) {
                PneumaticCraftUtils.getTileEntityAt((BlockGetter)player.m_9236_(), this.pos, PressureTubeBlockEntity.class).ifPresent(tube -> {
                    AbstractTubeModule patt3809$temp = tube.getModule(this.side);
                    if (patt3809$temp instanceof RedstoneModule) {
                        RedstoneModule mr = (RedstoneModule)patt3809$temp;
                        mr.setRedstoneDirection(this.input ? RedstoneModule.EnumRedstoneDirection.INPUT : RedstoneModule.EnumRedstoneDirection.OUTPUT);
                        mr.setColorChannel(this.ourColor);
                        if (this.input) {
                            mr.setComparatorInput(this.comparatorInput);
                        } else {
                            mr.setInverted(this.invert);
                            mr.setOperation(RedstoneModule.Operation.values()[this.op], this.otherColor, this.constantVal);
                        }
                        mr.updateNeighbors();
                        mr.updateInputLevel();
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

