/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class SeismicSensorItem
extends Item {
    private static final int MAX_SEARCH = 500;

    public SeismicSensorItem() {
        super(ModItems.defaultProps().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        if (level.f_46443_ && player != null) {
            BlockPos.MutableBlockPos searchPos = ctx.m_8083_().m_122032_();
            this.findFluid(level, (BlockPos)searchPos).ifPresentOrElse(result -> {
                int bottomOff;
                int topOff = ctx.m_8083_().m_123342_() - result.top().m_123342_();
                Object depthStr = topOff == (bottomOff = ctx.m_8083_().m_123342_() - result.bottom().m_123342_()) ? Integer.toString(topOff) : topOff + "-" + bottomOff;
                player.m_5661_((Component)Component.m_237110_((String)"pneumaticcraft.message.seismicSensor.foundOilDetails", (Object[])new Object[]{Component.m_237115_((String)result.fluid().getFluidType().getDescriptionId()), String.valueOf(ChatFormatting.GREEN) + (String)depthStr, ChatFormatting.GREEN.toString() + result.lakeSize()}), false);
                player.m_5496_((SoundEvent)SoundEvents.f_12211_.get(), 1.0f, 1.0f);
            }, () -> player.m_5661_((Component)Component.m_237115_((String)"pneumaticcraft.message.seismicSensor.noOilFound"), false));
        }
        return InteractionResult.SUCCESS;
    }

    private Optional<FluidSearchResult> findFluid(Level level, BlockPos origin) {
        BlockPos.MutableBlockPos searchPos = origin.m_122032_();
        while (searchPos.m_123342_() > level.m_141937_()) {
            searchPos.m_122173_(Direction.DOWN);
            Fluid fluid = this.getFluidOfInterest(level, (BlockPos)searchPos);
            if (fluid == null) continue;
            BlockPos top = searchPos.m_7949_();
            do {
                searchPos.m_122173_(Direction.DOWN);
            } while (searchPos.m_123342_() > level.m_141937_() && this.getFluidOfInterest(level, (BlockPos)searchPos) == fluid);
            BlockPos bottom = searchPos.m_7494_().m_7949_();
            Set<BlockPos> fluidPositions = this.findLake(level, top, fluid);
            int lakeSize = Math.max(1, fluidPositions.size() / 10 * 10);
            return Optional.of(new FluidSearchResult(fluid, top, bottom, lakeSize));
        }
        return Optional.empty();
    }

    private Fluid getFluidOfInterest(Level world, BlockPos pos) {
        FluidState state = world.m_6425_(pos);
        return state.m_76152_().m_205067_(PneumaticCraftTags.Fluids.SEISMIC) ? state.m_76152_() : null;
    }

    private Set<BlockPos> findLake(Level world, BlockPos searchPos, Fluid fluid) {
        HashSet<BlockPos> fluidPositions = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> pendingPositions = new ArrayDeque<BlockPos>();
        pendingPositions.add(searchPos);
        while (!pendingPositions.isEmpty() && fluidPositions.size() < 500) {
            BlockPos checkingPos = (BlockPos)pendingPositions.pop();
            for (Direction d : Direction.values()) {
                BlockPos newPos;
                FluidState state;
                if (d == Direction.UP || (state = world.m_6425_(newPos = checkingPos.m_121945_(d))).m_76152_() != fluid || !state.m_76170_() || !fluidPositions.add(newPos)) continue;
                pendingPositions.add(newPos);
            }
        }
        return fluidPositions;
    }

    record FluidSearchResult(Fluid fluid, BlockPos top, BlockPos bottom, int lakeSize) {
    }
}

