/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIDropItem;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemDropper;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetDropItem
extends ProgWidgetInventoryBase
implements IItemDropper {
    private boolean dropStraight;
    private boolean pickupDelay = true;

    public ProgWidgetDropItem() {
        super((ProgWidgetType)ModProgWidgets.DROP_ITEM.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.MAGENTA;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_DROP_ITEM;
    }

    @Override
    public boolean dropStraight() {
        return this.dropStraight;
    }

    @Override
    public void setDropStraight(boolean dropStraight) {
        this.dropStraight = dropStraight;
    }

    @Override
    public boolean hasPickupDelay() {
        return this.pickupDelay;
    }

    @Override
    public void setPickupDelay(boolean pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.dropStraight) {
            tag.m_128379_("dropStraight", true);
        }
        if (this.pickupDelay) {
            tag.m_128379_("pickupDelay", true);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.dropStraight = tag.m_128471_("dropStraight");
        this.pickupDelay = tag.m_128471_("pickupDelay");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.dropStraight);
        buf.writeBoolean(this.pickupDelay);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.dropStraight = buf.readBoolean();
        this.pickupDelay = buf.readBoolean();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.pickupDelay) {
            curTooltip.add((Component)Component.m_237115_((String)"pneumaticcraft.gui.progWidget.drop.hasPickupDelay"));
        } else {
            curTooltip.add((Component)Component.m_237115_((String)"pneumaticcraft.gui.progWidget.drop.noPickupDelay"));
        }
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIDropItem<ProgWidgetInventoryBase>(drone, (ProgWidgetInventoryBase)widget);
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.singletonList(PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.drop.dropMethod." + (this.dropStraight() ? "straight" : "random"), new Object[0]));
    }
}

