/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DroneClaimManager {
    private static final Map<ResourceLocation, DroneClaimManager> claimManagers = new HashMap<ResourceLocation, DroneClaimManager>();
    private final Map<BlockPos, Integer> currentPositions = new HashMap<BlockPos, Integer>();
    private static final int TIMEOUT = 4;

    public static DroneClaimManager getInstance(Level world) {
        return claimManagers.computeIfAbsent(world.m_46472_().m_135782_(), k -> new DroneClaimManager());
    }

    public void tick() {
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.currentPositions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = iterator.next();
            if (entry.getValue() < 4) {
                entry.setValue(entry.getValue() + 1);
                continue;
            }
            iterator.remove();
        }
    }

    public boolean isClaimed(BlockPos pos) {
        return this.currentPositions.containsKey(pos);
    }

    public void claim(BlockPos pos) {
        this.currentPositions.put(pos, 0);
    }
}

