/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AssemblyControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.block.entity.IResettable;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class AbstractAssemblyRobotBlockEntity
extends AbstractTickingBlockEntity
implements IAssemblyMachine,
IResettable {
    public final float[] oldAngles = new float[EnumAngles.values().length];
    @DescSynced
    @LazySynced
    public final float[] angles = new float[EnumAngles.values().length];
    @DescSynced
    final float[] targetAngles = new float[EnumAngles.values().length];
    TargetDirections targetDirection = null;
    @DescSynced
    boolean slowMode;
    @DescSynced
    protected float speed = 1.0f;
    private BlockPos controllerPos;

    AbstractAssemblyRobotBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.gotoHomePosition();
        System.arraycopy(this.targetAngles, 0, this.angles, 0, this.targetAngles.length);
        System.arraycopy(this.targetAngles, 0, this.oldAngles, 0, this.targetAngles.length);
    }

    @Override
    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        if (this.controllerPos != null) {
            this.nonNullLevel().m_141902_(this.controllerPos, (BlockEntityType)ModBlockEntities.ASSEMBLY_CONTROLLER.get()).ifPresent(AssemblyControllerBlockEntity::invalidateAssemblySystem);
        }
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        System.arraycopy(this.angles, 0, this.oldAngles, 0, this.angles.length);
        for (int i = 0; i < this.angles.length; ++i) {
            if (this.angles[i] > this.targetAngles[i]) {
                this.angles[i] = Math.max(this.angles[i] - 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
                continue;
            }
            if (!(this.angles[i] < this.targetAngles[i])) continue;
            this.angles[i] = Math.min(this.angles[i] + 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
        }
    }

    public void gotoHomePosition() {
        for (EnumAngles angle : EnumAngles.values()) {
            this.targetAngles[angle.getIndex()] = angle.getHomeAngle();
        }
    }

    boolean gotoTarget() {
        if (this.targetDirection != null) {
            this.gotoNeighbour(this.targetDirection);
            return this.isDoneMoving();
        }
        return false;
    }

    boolean hoverOverTarget() {
        if (this.targetDirection != null) {
            this.hoverOverNeighbour(this.targetDirection);
            return this.isDoneMoving();
        }
        return false;
    }

    public boolean gotoNeighbour(@Nonnull TargetDirections newDirections) {
        this.targetDirection = newDirections;
        boolean diagonal = true;
        boolean diagonalAllowed = this.canMoveToDiagonalNeighbours();
        switch (this.targetDirection.primary) {
            case SOUTH: {
                if (this.targetDirection.secondary == Direction.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.getIndex()] = -45.0f;
                    this.targetAngles[EnumAngles.HEAD.getIndex()] = 40.0f;
                    break;
                }
                if (this.targetDirection.secondary == Direction.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.getIndex()] = 45.0f;
                    this.targetAngles[EnumAngles.HEAD.getIndex()] = -40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.getIndex()] = 0.0f;
                this.targetAngles[EnumAngles.HEAD.getIndex()] = 90.0f;
                diagonal = false;
                break;
            }
            case EAST: {
                this.targetAngles[EnumAngles.TURN.getIndex()] = -90.0f;
                this.targetAngles[EnumAngles.HEAD.getIndex()] = 0.0f;
                diagonal = false;
                break;
            }
            case NORTH: {
                if (this.targetDirection.secondary == Direction.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.getIndex()] = -135.0f;
                    this.targetAngles[EnumAngles.HEAD.getIndex()] = -40.0f;
                    break;
                }
                if (this.targetDirection.secondary == Direction.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.getIndex()] = 135.0f;
                    this.targetAngles[EnumAngles.HEAD.getIndex()] = 40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.getIndex()] = 180.0f;
                this.targetAngles[EnumAngles.HEAD.getIndex()] = 90.0f;
                diagonal = false;
                break;
            }
            case WEST: {
                this.targetAngles[EnumAngles.TURN.getIndex()] = 90.0f;
                this.targetAngles[EnumAngles.HEAD.getIndex()] = 0.0f;
                diagonal = false;
            }
        }
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.getIndex()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.getIndex()] = -85.0f;
            this.targetAngles[EnumAngles.TAIL.getIndex()] = -20.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.getIndex()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.getIndex()] = -10.0f;
            this.targetAngles[EnumAngles.TAIL.getIndex()] = 0.0f;
        }
        return diagonal;
    }

    void hoverOverNeighbour(TargetDirections directions) {
        boolean diagonal = this.gotoNeighbour(directions);
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.getIndex()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.getIndex()] = -95.0f;
            this.targetAngles[EnumAngles.TAIL.getIndex()] = -10.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.getIndex()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.getIndex()] = -20.0f;
            this.targetAngles[EnumAngles.TAIL.getIndex()] = 10.0f;
        }
    }

    BlockEntity getTileEntityForCurrentDirection() {
        if (this.targetDirection == null) {
            return null;
        }
        if (this.targetDirection.secondary == null) {
            return this.getCachedNeighbor(this.targetDirection.primary);
        }
        return this.nonNullLevel().m_7702_(this.targetDirection.offset(this.getPosition()));
    }

    boolean isDoneMoving() {
        for (int i = 0; i < this.angles.length; ++i) {
            if (PneumaticCraftUtils.epsilonEquals(this.angles[i], this.targetAngles[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        for (int i = 0; i < 5; ++i) {
            this.angles[i] = tag.m_128457_("angle" + i);
            this.targetAngles[i] = tag.m_128457_("targetAngle" + i);
        }
        this.slowMode = tag.m_128471_("slowMode");
        this.speed = tag.m_128457_("speed");
        this.targetDirection = TargetDirections.readNBT(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        for (int i = 0; i < 5; ++i) {
            tag.m_128350_("angle" + i, this.angles[i]);
            tag.m_128350_("targetAngle" + i, this.targetAngles[i]);
        }
        tag.m_128379_("slowMode", this.slowMode);
        tag.m_128350_("speed", this.speed);
        if (this.targetDirection != null) {
            this.targetDirection.writeNBT(tag);
        }
    }

    protected abstract boolean canMoveToDiagonalNeighbours();

    TargetDirections getPlatformDirection() {
        Level level = this.nonNullLevel();
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            if (!(level.m_7702_(this.m_58899_().m_121945_(dir)) instanceof AssemblyPlatformBlockEntity)) continue;
            return new TargetDirections(dir);
        }
        if (this.canMoveToDiagonalNeighbours()) {
            for (Direction secDir : new Direction[]{Direction.WEST, Direction.EAST}) {
                for (Direction primDir : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
                    if (!(level.m_7702_(this.m_58899_().m_121945_(primDir).m_121945_(secDir)) instanceof AssemblyPlatformBlockEntity)) continue;
                    return new TargetDirections(primDir, secDir);
                }
            }
        }
        return null;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.m_58899_().m_123341_() - 1), (double)(this.m_58899_().m_123342_() - 1), (double)(this.m_58899_().m_123343_() - 1), (double)(this.m_58899_().m_123341_() + 2), (double)(this.m_58899_().m_123342_() + 2), (double)(this.m_58899_().m_123343_() + 2));
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    static enum EnumAngles {
        TURN(0),
        BASE(1),
        MIDDLE(2, 55.0f),
        TAIL(3, 35.0f),
        HEAD(4);

        private final int idx;
        private final float homeAngle;

        private EnumAngles(int idx) {
            this(idx, 0.0f);
        }

        private EnumAngles(int idx, float homeAngle) {
            this.idx = idx;
            this.homeAngle = homeAngle;
        }

        public int getIndex() {
            return this.idx;
        }

        public float getHomeAngle() {
            return this.homeAngle;
        }
    }

    static class TargetDirections {
        final Direction primary;
        final Direction secondary;

        TargetDirections(@Nonnull Direction primary, Direction secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        TargetDirections(@Nonnull Direction primary) {
            this(primary, null);
        }

        BlockPos offset(BlockPos initial) {
            return this.secondary == null ? initial.m_121945_(this.primary) : initial.m_121945_(this.primary).m_121945_(this.secondary);
        }

        static TargetDirections readNBT(CompoundTag tag) {
            if (!tag.m_128441_("targetDir1")) {
                return null;
            }
            return new TargetDirections(DirectionUtil.VALUES[tag.m_128451_("targetDir1")], tag.m_128441_("targetDir2") ? DirectionUtil.VALUES[tag.m_128451_("targetDir2")] : null);
        }

        void writeNBT(CompoundTag tag) {
            tag.m_128405_("targetDir1", this.primary.m_122411_());
            if (this.secondary != null) {
                tag.m_128405_("targetDir2", this.secondary.m_122411_());
            }
        }
    }
}

