/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.misc.RangedInt;
import me.desht.pneumaticcraft.api.universal_sensor.ISensorSetting;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRangeToggleButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.UniversalSensorBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.UniversalSensorMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UniversalSensorScreen
extends AbstractPneumaticCraftContainerScreen<UniversalSensorMenu, UniversalSensorBlockEntity> {
    private static final int MAX_TEXTFIELD_LENGTH = 256;
    private WidgetAnimatedStat sensorInfoStat;
    private WidgetTextField textField;
    private WidgetComboBox comboBox;
    private int page;
    private int maxPage;
    private static final int MAX_SENSORS_PER_PAGE = 4;
    private int ticksExisted;
    private final List<AbstractWidget> sensorButtons = new ArrayList<AbstractWidget>();

    public UniversalSensorScreen(UniversalSensorMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97727_ = 239;
    }

    public static void refreshIfOpen() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof UniversalSensorScreen) {
            UniversalSensorScreen us = (UniversalSensorScreen)screen;
            us.updateButtons();
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_UNIVERSAL_SENSOR;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        this.sensorInfoStat = this.addAnimatedStat((Component)Component.m_237113_((String)"Sensor Info"), new ItemStack((ItemLike)ModBlocks.UNIVERSAL_SENSOR.get()), -22016, false);
        this.sensorInfoStat.setForegroundColor(-16777216);
        this.textField = new WidgetTextField(this.f_96547_, xStart + 70, yStart + 58, 98, 10);
        this.textField.m_94199_(256);
        this.textField.m_94144_(((UniversalSensorBlockEntity)this.te).getText(0));
        this.m_142416_((GuiEventListener)this.textField);
        this.comboBox = new WidgetComboBox(this.f_96547_, xStart + 70, yStart + 58, 98, 10);
        this.comboBox.m_94199_(256);
        this.comboBox.m_94144_(((UniversalSensorBlockEntity)this.te).getText(0));
        this.m_142416_((GuiEventListener)this.comboBox);
        this.comboBox.m_94194_(false);
        this.updateButtons();
    }

    @Override
    protected void m_280003_(GuiGraphics graphics, int x, int y) {
        String[] folders;
        super.m_280003_(graphics, x, y);
        if (this.maxPage > 1) {
            graphics.m_280056_(this.f_96547_, this.page + "/" + this.maxPage, 110, 134, 0x404040, false);
        }
        if ((folders = ((UniversalSensorBlockEntity)this.te).getSensorSetting().split("/")).length == 1 && !folders[0].isEmpty()) {
            Set<PNCUpgrade> requiredUpgrades = SensorHandler.getInstance().getRequiredStacksFromText(folders[0]);
            int curX = 92;
            for (PNCUpgrade upgrade : requiredUpgrades) {
                graphics.m_280480_(upgrade.getItemStack(), curX, 20);
                curX += 18;
            }
        } else {
            int xSpace = this.f_97726_ - 92;
            int size = this.f_96547_.m_92895_(folders[folders.length - 1]);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(88.0f, 24.0f, 0.0f);
            if (size > xSpace) {
                graphics.m_280168_().m_85841_((float)xSpace / (float)size, 1.0f, 1.0f);
            }
            graphics.m_280056_(this.f_96547_, folders[folders.length - 1], 0, 0, 0x4040A0, false);
            graphics.m_280168_().m_85849_();
        }
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((UniversalSensorBlockEntity)this.te).getSensorSetting());
        if (sensor != null) {
            ArrayList<Component> info = new ArrayList<Component>();
            sensor.getAdditionalInfo(info);
            int yOff = 0;
            for (Component line : info) {
                graphics.m_280649_(this.f_96547_, line.m_7532_(), 70, 48 + yOff, 0x404040, false);
                Objects.requireNonNull(this.f_96547_);
                yOff += 9;
            }
            this.textField.m_253211_(this.f_97736_ + 48 + yOff + 2);
        }
        if (sensor != null && !sensor.getHelpText().isEmpty()) {
            if (ClientUtils.isKeyDown(290)) {
                GuiUtils.showPopupHelpScreen(graphics, (Screen)this, this.f_96547_, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
            } else if (!sensor.getHelpPromptText().isEmpty()) {
                MutableComponent str = Component.m_237115_((String)sensor.getHelpPromptText());
                graphics.m_280614_(this.f_96547_, (Component)str, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)str)) / 2, this.f_97727_ + 5, 0xFFFF00, false);
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            ClientUtils.getClientPlayer().m_6915_();
        }
        return this.textField.m_7933_(keyCode, scanCode, modifiers) || this.textField.m_94204_() || this.comboBox.m_7933_(keyCode, scanCode, modifiers) || this.comboBox.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    protected PointXY getInvTextOffset() {
        return new PointXY(0, 2);
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        return new PointXY(xStart + 34, yStart + this.f_97727_ / 4 - 18);
    }

    private void updateButtons() {
        this.sensorButtons.forEach(this::removeWidget);
        this.sensorButtons.clear();
        String[] directories = SensorHandler.getInstance().getDirectoriesAtLocation(((UniversalSensorBlockEntity)this.te).getSensorSetting());
        if (!((UniversalSensorBlockEntity)this.te).getSensorSetting().isEmpty()) {
            this.addButtonLocal((AbstractWidget)new WidgetButtonExtended(this.f_97735_ + 70, this.f_97736_ + 20, 16, 16, "\u27f5").withTag("back"));
        }
        if (directories.length == 0 || ((UniversalSensorBlockEntity)this.te).getSensorSetting().isEmpty()) {
            this.addButtonLocal((AbstractWidget)new WidgetRangeToggleButton(this.f_97735_ + 150, this.f_97736_ + 130, (IRangedTE)((Object)this.te)));
        }
        this.maxPage = (directories.length - 1) / 4 + 1;
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.maxPage > 1) {
            this.addButtonLocal((AbstractWidget)new WidgetButtonExtended(this.f_97735_ + 70, this.f_97736_ + 40 + 88, 30, 20, "\u25c0", b -> {
                --this.page;
                if (this.page <= 0) {
                    this.page = this.maxPage;
                }
                this.updateButtons();
            }));
            this.addButtonLocal((AbstractWidget)new WidgetButtonExtended(this.f_97735_ + 138, this.f_97736_ + 40 + 88, 30, 20, "\u25b6", b -> {
                ++this.page;
                if (this.page > this.maxPage) {
                    this.page = 1;
                }
                this.updateButtons();
            }));
        }
        int buttonsOnPage = 4;
        if (this.page == this.maxPage && (directories.length % 4 > 0 || directories.length == 0)) {
            buttonsOnPage = directories.length % 4;
        }
        for (int i = 0; i < buttonsOnPage; ++i) {
            Object buttonText = directories[i + (this.page - 1) * 4];
            if (SensorHandler.getInstance().getSensorFromPath(((UniversalSensorBlockEntity)this.te).getSensorSetting() + "/" + (String)buttonText) != null) {
                buttonText = String.valueOf(ChatFormatting.YELLOW) + (String)buttonText;
            }
            int buttonID = i * 10 + 10 + (this.page - 1) * 4 * 10;
            int buttonX = this.f_97735_ + 70;
            int buttonY = this.f_97736_ + 40 + i * 22;
            int buttonWidth = 98;
            int buttonHeight = 20;
            if (((UniversalSensorBlockEntity)this.te).getSensorSetting().isEmpty()) {
                Set<PNCUpgrade> requiredUpgrades = SensorHandler.getInstance().getRequiredStacksFromText((String)buttonText);
                WidgetButtonExtended button = new WidgetButtonExtended(buttonX, buttonY, buttonWidth, buttonHeight, "").withTag("set:" + buttonID);
                button.setRenderStacks((ItemStack[])requiredUpgrades.stream().map(PNCUpgrade::getItemStack).toArray(ItemStack[]::new));
                button.f_93623_ = (((UniversalSensorBlockEntity)this.te).sensorStatus == UniversalSensorBlockEntity.SensorStatus.OK || ((UniversalSensorBlockEntity)this.te).sensorStatus == UniversalSensorBlockEntity.SensorStatus.NO_SENSOR) && ((UniversalSensorBlockEntity)this.te).areGivenUpgradesInserted(requiredUpgrades);
                this.addButtonLocal((AbstractWidget)button);
                continue;
            }
            this.addButtonLocal((AbstractWidget)new WidgetButtonExtended(buttonX, buttonY, buttonWidth, buttonHeight, (String)buttonText).withTag("set:" + buttonID));
        }
        this.sensorInfoStat.setText(this.getSensorInfo());
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((UniversalSensorBlockEntity)this.te).getSensorSetting());
        boolean textboxEnabled = sensor != null && sensor.needsTextBox();
        List<String> textOptions = sensor == null ? null : sensor.getTextBoxOptions(ClientUtils.getClientPlayer());
        this.textField.m_94194_(textboxEnabled && textOptions == null);
        this.comboBox.m_94194_(textboxEnabled && textOptions != null);
        if (textboxEnabled) {
            if (textOptions == null) {
                RangedInt range = sensor.getTextboxIntRange();
                if (range != null) {
                    this.textField.m_94153_(s -> this.validateTextValue((String)s, range));
                    String max = Integer.toString(range.max());
                    this.textField.m_94199_(max.length() + 1);
                    this.textField.m_93674_(this.f_96547_.m_92895_(max) + 10);
                } else {
                    this.textField.m_94153_(Objects::nonNull);
                    this.textField.m_94199_(256);
                    this.textField.m_93674_(98);
                }
                this.m_7522_((GuiEventListener)this.textField);
            } else {
                this.comboBox.setElements(textOptions);
                this.comboBox.setShouldSort(true);
                this.comboBox.setFixedOptions(sensor.strictComboBox());
                this.m_7522_((GuiEventListener)this.comboBox);
            }
        }
    }

    private boolean validateTextValue(String s, RangedInt r) {
        if (PneumaticCraftUtils.isInteger(s)) {
            int n = s.isEmpty() || s.equals("-") ? 0 : Integer.parseInt(s);
            return r.test(n);
        }
        return false;
    }

    private void addButtonLocal(AbstractWidget w) {
        this.m_142416_((GuiEventListener)w);
        this.sensorButtons.add(w);
    }

    @Override
    protected void doDelayedAction() {
        if (this.textField.m_94213_()) {
            ((UniversalSensorBlockEntity)this.te).setText(0, this.textField.m_94155_());
        } else if (this.comboBox.m_94213_()) {
            ((UniversalSensorBlockEntity)this.te).setText(0, this.comboBox.m_94155_());
        }
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    @Override
    public void m_181908_() {
        if (this.firstUpdate) {
            if (this.textField.m_94213_()) {
                this.textField.m_94144_(((UniversalSensorBlockEntity)this.te).getText(0));
                this.textField.m_94151_(s -> this.sendDelayed(5));
            } else if (this.comboBox.m_94213_()) {
                this.comboBox.m_94144_(((UniversalSensorBlockEntity)this.te).getText(0));
                this.comboBox.m_94151_(s -> this.sendDelayed(5));
            }
        }
        super.m_181908_();
        if (((UniversalSensorBlockEntity)this.te).getSensorSetting().isEmpty() && this.ticksExisted++ > 5) {
            this.ticksExisted = 0;
            this.updateButtons();
        }
    }

    private List<Component> getSensorInfo() {
        ArrayList<Component> text = new ArrayList<Component>();
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((UniversalSensorBlockEntity)this.te).getSensorSetting());
        if (sensor != null) {
            String[] folders = ((UniversalSensorBlockEntity)this.te).getSensorSetting().split("/");
            text.add((Component)Component.m_237113_((String)folders[folders.length - 1]).m_130940_(ChatFormatting.WHITE));
            text.addAll(GuiUtils.xlateAndSplit(sensor.getDescription().get(0), new Object[0]));
        } else {
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.none", new Object[0]).m_130940_(ChatFormatting.BLACK));
        }
        return text;
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((UniversalSensorBlockEntity)this.te).isSensorActive) {
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.airUsage", 1).m_130940_(ChatFormatting.BLACK));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        if (!((UniversalSensorBlockEntity)this.te).getPrimaryInventory().getStackInSlot(0).m_41619_() && ((UniversalSensorBlockEntity)this.te).outOfRange > 0) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.universalSensor.outOfRange", ((UniversalSensorBlockEntity)this.te).outOfRange));
        }
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (!((UniversalSensorBlockEntity)this.te).lastSensorExceptionText.isEmpty()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.universalSensor.sensorException", ((UniversalSensorBlockEntity)this.te).lastSensorExceptionText));
        }
        if (((UniversalSensorBlockEntity)this.te).sensorStatus != UniversalSensorBlockEntity.SensorStatus.OK) {
            curInfo.addAll(GuiUtils.xlateAndSplit(((UniversalSensorBlockEntity)this.te).sensorStatus.getTranslationKey(), new Object[0]));
        }
    }
}

