/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodchest;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import org.cyclops.evilcraft.block.BlockColossalBloodChestConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityColossalBloodChest;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.helper.MathHelpers;

public class BulkRepairItemTickAction
implements ITickAction<BlockEntityColossalBloodChest> {
    @Override
    public boolean canTick(BlockEntityColossalBloodChest tile, ItemStack itemStack, int slot, int tick) {
        return tile.canWork() && !tile.getTank().isEmpty() && !itemStack.m_41619_();
    }

    private void drainTank(BlockEntityColossalBloodChest tile, float usageMultiplier, int tick) {
        tile.getTank().drain(this.getRequiredFluid(tile, usageMultiplier, tick), IFluidHandler.FluidAction.EXECUTE);
    }

    protected int getRequiredFluid(BlockEntityColossalBloodChest tile, float usageMultiplier, int tick) {
        MutableFloat drain = new MutableFloat((Number)Math.max(0.05, (double)((float)BlockColossalBloodChestConfig.baseMBPerDamage * usageMultiplier * (1.0f - (float)tile.getEfficiency().intValue() / 210.0f))));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableFloat>(drain, BlockEntityColossalBloodChest.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue().floatValue(), (int)tile.m_58904_().m_46467_() + tick % 100);
    }

    @Override
    public void onTick(BlockEntityColossalBloodChest tile, ItemStack itemStack, int slot, int tick) {
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick) && !tile.getTank().isEmpty() && !itemStack.m_41619_()) {
            itemStack = itemStack.m_41777_();
            IBloodChestRepairActionRegistry actions = (IBloodChestRepairActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBloodChestRepairActionRegistry.class);
            int actionID = actions.canRepair(itemStack, tick);
            if (actionID > -1) {
                float simulateMultiplier = ((Float)actions.repair(itemStack, tile.m_58904_().f_46441_, actionID, false, true).getLeft()).floatValue();
                if ((float)tile.getTank().getFluidAmount() >= (float)this.getRequiredFluid(tile, simulateMultiplier, tick) * simulateMultiplier) {
                    Boolean slotHistory = tile.getSlotTickHistory().get(slot);
                    if (slotHistory == null || !slotHistory.booleanValue()) {
                        tile.setEfficiency(Math.min(tile.getEfficiency() + 1, 200));
                        tile.getSlotTickHistory().put(slot, true);
                    }
                    Pair<Float, ItemStack> repairResult = actions.repair(itemStack, tile.m_58904_().f_46441_, actionID, true, true);
                    itemStack = (ItemStack)repairResult.getRight();
                    this.drainTank(tile, ((Float)repairResult.getLeft()).floatValue(), tick);
                }
            }
            tile.getInventory().m_6836_(slot, itemStack);
        }
    }

    @Override
    public float getRequiredTicks(BlockEntityColossalBloodChest tile, int slot, int tick) {
        MutableFloat duration = new MutableFloat((float)BlockColossalBloodChestConfig.ticksPerDamage);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableFloat>(duration, BlockEntityColossalBloodChest.UPGRADEEVENT_SPEED));
        return duration.getValue().floatValue();
    }
}

