/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolspower.RFToolsPower;
import mcjty.rftoolspower.compat.RFToolsDimensionChecker;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellModule;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DimensionalCellNetwork
extends AbstractWorldData<DimensionalCellNetwork> {
    private static final String DIMENSIONALCELL_NETWORK_NAME = "RFToolsDimensionalCellNetwork";
    private int lastId = 0;
    private final Map<Integer, Network> networks = new HashMap<Integer, Network>();

    public DimensionalCellNetwork() {
    }

    public DimensionalCellNetwork(CompoundTag tag) {
        ListTag lst = tag.m_128437_("networks", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundTag tc = lst.m_128728_(i);
            int channel = tc.m_128451_("channel");
            Network value = new Network();
            value.readFromNBT(tc);
            this.networks.put(channel, value);
        }
        this.lastId = tag.m_128451_("lastId");
    }

    public static DimensionalCellNetwork get(Level world) {
        return (DimensionalCellNetwork)DimensionalCellNetwork.getData((Level)world, DimensionalCellNetwork::new, DimensionalCellNetwork::new, (String)DIMENSIONALCELL_NETWORK_NAME);
    }

    public Network getOrCreateNetwork(int id) {
        Network channel = this.networks.get(id);
        if (channel == null) {
            channel = new Network();
            this.networks.put(id, channel);
        }
        return channel;
    }

    public Network getChannel(int id) {
        return this.networks.get(id);
    }

    public void deleteChannel(int id) {
        this.networks.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tagCompound) {
        ListTag lst = new ListTag();
        for (Map.Entry<Integer, Network> entry : this.networks.entrySet()) {
            CompoundTag tc = new CompoundTag();
            tc.m_128405_("channel", entry.getKey().intValue());
            entry.getValue().writeToNBT(tc);
            lst.add((Object)tc);
        }
        tagCompound.m_128365_("networks", (Tag)lst);
        tagCompound.m_128405_("lastId", this.lastId);
        return tagCompound;
    }

    public static class Network {
        private int energy = 0;
        private Set<GlobalPos> blocks = new HashSet<GlobalPos>();
        private int simpleBlocks = 0;
        private int advancedBlocks = 0;
        private Map<GlobalPos, Float> costFactor = null;

        public Set<GlobalPos> getBlocks() {
            return this.blocks;
        }

        public int getBlockCount() {
            return this.blocks.size();
        }

        public int getAdvancedBlockCount() {
            return this.advancedBlocks;
        }

        public int getSimpleBlockCount() {
            return this.simpleBlocks;
        }

        public int calculateMaximumEnergy() {
            long totEnergyLong = (long)((Integer)DimensionalCellConfiguration.rfPerNormalCell.get()).intValue() * (long)(this.getBlockCount() - this.getAdvancedBlockCount() - this.getSimpleBlockCount()) + (long)((Integer)DimensionalCellConfiguration.rfPerNormalCell.get()).intValue() * (long)((Integer)DimensionalCellConfiguration.advancedFactor.get()).intValue() * (long)this.getAdvancedBlockCount() + (long)((Integer)DimensionalCellConfiguration.rfPerNormalCell.get()).intValue() * (long)this.getSimpleBlockCount() / (long)((Integer)DimensionalCellConfiguration.simpleFactor.get()).intValue();
            if (totEnergyLong > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)totEnergyLong;
        }

        public void updateNetwork(Level w) {
            this.advancedBlocks = 0;
            this.simpleBlocks = 0;
            HashSet<GlobalPos> copy = new HashSet<GlobalPos>(this.blocks);
            this.blocks.clear();
            for (GlobalPos c : copy) {
                ServerLevel world = LevelTools.getLevel((ResourceKey)c.m_122640_());
                BlockState state = world.m_8055_(c.m_122646_());
                if (state.m_60734_() == DimensionalCellModule.DIMENSIONAL_CELL.get()) {
                    this.blocks.add(c);
                    continue;
                }
                if (DimensionalCellBlock.getType(state.m_60734_()).isAdvanced()) {
                    this.blocks.add(c);
                    ++this.advancedBlocks;
                    continue;
                }
                if (DimensionalCellBlock.getType(state.m_60734_()).isSimple()) {
                    this.blocks.add(c);
                    ++this.simpleBlocks;
                    continue;
                }
                Logging.log((String)"Warning! Powercell network data was not up-to-date!");
            }
        }

        public void add(Level world, GlobalPos g, DimensionalCellType type) {
            if (!this.blocks.contains(g)) {
                this.blocks.add(g);
                this.costFactor = null;
                if (type.isAdvanced()) {
                    ++this.advancedBlocks;
                }
                if (type.isSimple()) {
                    ++this.simpleBlocks;
                }
                this.updateNetwork(world);
            }
        }

        public void remove(Level world, GlobalPos g, DimensionalCellType type) {
            if (this.blocks.contains(g)) {
                this.blocks.remove(g);
                this.costFactor = null;
                if (type.isAdvanced()) {
                    --this.advancedBlocks;
                }
                if (type.isSimple()) {
                    --this.simpleBlocks;
                }
                this.updateNetwork(world);
            }
        }

        private double calculateBlobDistance(Level world, Set<GlobalPos> blob1, Set<GlobalPos> blob2) {
            GlobalPos c1 = blob1.iterator().next();
            GlobalPos c2 = blob2.iterator().next();
            boolean dim1rftools = RFToolsPower.setup.rftoolsDimensions && RFToolsDimensionChecker.isRFToolsDimension(world, (Level)LevelTools.getLevel((ResourceKey)c1.m_122640_()));
            boolean dim2rftools = RFToolsPower.setup.rftoolsDimensions && RFToolsDimensionChecker.isRFToolsDimension(world, (Level)LevelTools.getLevel((ResourceKey)c2.m_122640_()));
            double rftoolsdimMult = 1.0;
            if (dim1rftools) {
                rftoolsdimMult *= ((Double)DimensionalCellConfiguration.powerCellRFToolsDimensionAdvantage.get()).doubleValue();
            }
            if (dim2rftools) {
                rftoolsdimMult *= ((Double)DimensionalCellConfiguration.powerCellRFToolsDimensionAdvantage.get()).doubleValue();
            }
            if (!c1.m_122640_().equals((Object)c2.m_122640_())) {
                return (Double)DimensionalCellConfiguration.powerCellDistanceCap.get() * rftoolsdimMult;
            }
            double dist = Math.sqrt(c1.m_122646_().m_123331_((Vec3i)c2.m_122646_()));
            if (dist > (Double)DimensionalCellConfiguration.powerCellDistanceCap.get()) {
                dist = (Double)DimensionalCellConfiguration.powerCellDistanceCap.get();
            } else if (dist < (Double)DimensionalCellConfiguration.powerCellMinDistance.get()) {
                dist = (Double)DimensionalCellConfiguration.powerCellMinDistance.get();
            }
            return dist * rftoolsdimMult;
        }

        private void updateCostFactor(Level world) {
            if (this.costFactor == null) {
                this.costFactor = new HashMap<GlobalPos, Float>();
                ArrayList<Set<GlobalPos>> blobs = new ArrayList<Set<GlobalPos>>();
                this.getBlobs(blobs);
                for (Set set : blobs) {
                    double totalfactor = 1.0;
                    for (Set set2 : blobs) {
                        if (set2 == set) continue;
                        double dist = this.calculateBlobDistance(world, set, set2);
                        double part = (double)set2.size() / (double)this.blocks.size();
                        double factor = 1.0 + dist / (Double)DimensionalCellConfiguration.powerCellDistanceCap.get() * ((Double)DimensionalCellConfiguration.powerCellCostFactor.get() - 1.0) * part;
                        totalfactor += factor;
                    }
                    totalfactor /= (double)blobs.size();
                    for (GlobalPos globalPos : set) {
                        this.costFactor.put(globalPos, Float.valueOf((float)totalfactor));
                    }
                }
            }
        }

        private void getBlob(Set<GlobalPos> todo, Set<GlobalPos> blob, GlobalPos coordinate) {
            blob.add(coordinate);
            for (Direction facing : OrientationTools.DIRECTION_VALUES) {
                GlobalPos offset = GlobalPos.m_122643_((ResourceKey)coordinate.m_122640_(), (BlockPos)coordinate.m_122646_().m_121945_(facing));
                if (!todo.contains(offset)) continue;
                todo.remove(offset);
                this.getBlob(todo, blob, offset);
            }
        }

        private void getBlobs(List<Set<GlobalPos>> blobs) {
            HashSet<GlobalPos> todo = new HashSet<GlobalPos>(this.blocks);
            while (!todo.isEmpty()) {
                GlobalPos coordinate = (GlobalPos)todo.iterator().next();
                todo.remove(coordinate);
                HashSet<GlobalPos> blob = new HashSet<GlobalPos>();
                this.getBlob(todo, blob, coordinate);
                blobs.add(blob);
            }
        }

        public float calculateCostFactor(Level world, GlobalPos g) {
            this.updateCostFactor(world);
            Float f = this.costFactor.get(g);
            return f == null ? 1.0f : f.floatValue();
        }

        public int getEnergySingleBlock(DimensionalCellType type) {
            int simpleBlockCount = Math.max(1, (this.blocks.size() - this.advancedBlocks - this.simpleBlocks) * (Integer)DimensionalCellConfiguration.simpleFactor.get() + this.advancedBlocks * (Integer)DimensionalCellConfiguration.advancedFactor.get() * (Integer)DimensionalCellConfiguration.simpleFactor.get() + this.simpleBlocks);
            long rc = this.energy / simpleBlockCount;
            if (type.isAdvanced()) {
                rc *= (long)((Integer)DimensionalCellConfiguration.advancedFactor.get()).intValue() * (long)((Integer)DimensionalCellConfiguration.simpleFactor.get()).intValue();
            } else if (!type.isSimple()) {
                rc *= (long)((Integer)DimensionalCellConfiguration.simpleFactor.get()).intValue();
            }
            return rc > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rc;
        }

        public int extractEnergySingleBlock(DimensionalCellType type) {
            return this.extractEnergy(this.getEnergySingleBlock(type));
        }

        public int getEnergy() {
            return this.energy;
        }

        public int extractEnergy(int amount) {
            if (amount > this.energy) {
                amount = this.energy;
            }
            this.energy -= amount;
            return amount;
        }

        public int receiveEnergy(int amount) {
            if (amount > Integer.MAX_VALUE - this.energy) {
                amount = Integer.MAX_VALUE - this.energy;
            }
            this.energy += amount;
            return amount;
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }

        public void writeToNBT(CompoundTag tagCompound) {
            tagCompound.m_128405_("energy", this.energy);
            tagCompound.m_128405_("advanced", this.advancedBlocks);
            tagCompound.m_128405_("simple", this.simpleBlocks);
            ListTag list = new ListTag();
            for (GlobalPos block : this.blocks) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("dim", block.m_122640_().m_135782_().toString());
                tag.m_128405_("x", block.m_122646_().m_123341_());
                tag.m_128405_("y", block.m_122646_().m_123342_());
                tag.m_128405_("z", block.m_122646_().m_123343_());
                list.add((Object)tag);
            }
            tagCompound.m_128365_("blocks", (Tag)list);
        }

        public void readFromNBT(CompoundTag tagCompound) {
            this.energy = tagCompound.m_128451_("energy");
            this.advancedBlocks = tagCompound.m_128451_("advanced");
            this.simpleBlocks = tagCompound.m_128451_("simple");
            this.blocks.clear();
            ListTag list = tagCompound.m_128437_("blocks", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.m_128728_(i);
                ResourceLocation id = new ResourceLocation(tag.m_128461_("dim"));
                ResourceKey type = LevelTools.getId((ResourceLocation)id);
                BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
                this.blocks.add(GlobalPos.m_122643_((ResourceKey)type, (BlockPos)pos));
            }
        }
    }
}

