/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;

public enum RotorBladeState implements StringRepresentable
{
    HIDDEN,
    Y_X_POS,
    Y_X_NEG,
    Y_Z_POS,
    Y_Z_NEG,
    X_Y_POS,
    X_Y_NEG,
    X_Z_POS,
    X_Z_NEG,
    Z_Y_POS,
    Z_Y_NEG,
    Z_X_POS,
    Z_X_NEG;

    public static RotorBladeState[] VALUES;
    private static final Map<String, RotorBladeState> NAME_LOOKUP;
    private final String _name = CodeHelper.neutralLowercase((String)this.name());

    public static RotorBladeState getDefault() {
        return Z_X_POS;
    }

    public static RotorBladeState from(String name) {
        return NAME_LOOKUP.getOrDefault(CodeHelper.neutralLowercase((String)name), HIDDEN);
    }

    public static RotorBladeState from(RotorShaftState shaftState, Direction bladeDirection) {
        return RotorBladeState.from(switch (shaftState.getAxis()) {
            case Direction.Axis.X -> "x_" + bladeDirection.m_122434_().m_7912_() + (bladeDirection.m_122421_() == Direction.AxisDirection.POSITIVE ? "_neg" : "_pos");
            case Direction.Axis.Y -> "y_" + bladeDirection.m_122434_().m_7912_() + (bladeDirection.m_122421_() == Direction.AxisDirection.POSITIVE ? "_neg" : "_pos");
            case Direction.Axis.Z -> "z_" + bladeDirection.m_122434_().m_7912_() + (bladeDirection.m_122421_() == Direction.AxisDirection.POSITIVE ? "_neg" : "_pos");
            default -> shaftState.m_7912_() + (bladeDirection.m_122424_().m_122421_() == Direction.AxisDirection.POSITIVE ? "_pos" : "_neg");
        });
    }

    public String m_7912_() {
        return this._name;
    }

    public String toString() {
        return this.m_7912_();
    }

    static {
        VALUES = RotorBladeState.values();
        NAME_LOOKUP = Arrays.stream(RotorBladeState.values()).collect(Collectors.toMap(RotorBladeState::m_7912_, state -> state));
    }
}

