/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.container;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineControllerEntity;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.BooleanData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.EnumData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FloatData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FluidStackData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IntData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.WideAmountData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class TurbineControllerContainer
extends ModTileContainer<TurbineControllerEntity> {
    public final BooleanData ACTIVE;
    public final FluidStackData COOLANT_STACK;
    public final FluidStackData VAPOR_STACK;
    public final FloatData RPM;
    public final WideAmountData ENERGY_STORED;
    public final WideAmountData ENERGY_GENERATED_LAST_TICK;
    public final IntData FLUID_CONSUMED_LAST_TICK;
    public final FloatData ROTOR_EFFICIENCY_LAST_TICK;
    public final BooleanData INDUCTOR_ENGAGED;
    public final EnumData<VentSetting> VENT_SETTINGS;
    private final EnergySystem _outputEnergySystem;
    private final WideAmount _energyCapacity;
    private final int _fluidCapacity;
    private final int _rotorBladesCount;
    private final int _baseFluidPerBlade;
    private final int _maxIntakeRateHardLimit;
    private final int _maxIntakeRate;
    private final float _maxRotorSpeed;

    public TurbineControllerContainer(int windowId, Inventory playerInventory, TurbineControllerEntity controller) {
        super(5, ContainerFactory.EMPTY, (MenuType)Content.ContainerTypes.TURBINE_CONTROLLER.get(), windowId, playerInventory, (AbstractModBlockEntity)controller);
        MultiblockTurbine turbine = (MultiblockTurbine)controller.getMultiblockController().orElseThrow(IllegalStateException::new);
        boolean isClientSide = turbine.getWorld().m_5776_();
        this._outputEnergySystem = turbine.getOutputEnergySystem();
        this._energyCapacity = turbine.getCapacity(this._outputEnergySystem);
        this._fluidCapacity = turbine.getFluidContainer().getCapacity();
        this._rotorBladesCount = turbine.getRotorBladesCount();
        this._baseFluidPerBlade = turbine.getVariant().getBaseFluidPerBlade();
        this._maxIntakeRateHardLimit = turbine.getMaxIntakeRateHardLimit();
        this._maxIntakeRate = turbine.getMaxIntakeRate();
        this._maxRotorSpeed = turbine.getVariant().getMaxRotorSpeed();
        this.ACTIVE = BooleanData.of((ModContainer)this, (boolean)isClientSide, () -> () -> ((MultiblockTurbine)turbine).isMachineActive());
        this.COOLANT_STACK = turbine.getFluidContainer().getCoolantStackData(2, (ModContainer)this, isClientSide);
        this.VAPOR_STACK = turbine.getFluidContainer().getVaporStackData(2, (ModContainer)this, isClientSide);
        this.RPM = FloatData.of((ModContainer)this, (boolean)isClientSide, () -> turbine::getRotorSpeed);
        this.ENERGY_STORED = WideAmountData.sampled((int)3, (ModContainer)this, (boolean)isClientSide, () -> () -> turbine.getEnergyStored(this.getOutputEnergySystem()));
        this.ENERGY_GENERATED_LAST_TICK = WideAmountData.of((ModContainer)this, (boolean)isClientSide, () -> () -> WideAmount.from((double)turbine.getEnergyGeneratedLastTick()));
        this.FLUID_CONSUMED_LAST_TICK = IntData.of((ModContainer)this, (boolean)isClientSide, () -> turbine::getFluidConsumedLastTick);
        this.ROTOR_EFFICIENCY_LAST_TICK = FloatData.of((ModContainer)this, (boolean)isClientSide, () -> turbine::getRotorEfficiencyLastTick);
        this.INDUCTOR_ENGAGED = BooleanData.of((ModContainer)this, (boolean)isClientSide, () -> turbine::isInductorEngaged);
        this.VENT_SETTINGS = EnumData.of((ModContainer)this, (boolean)isClientSide, VentSetting.class, () -> turbine::getVentSetting);
    }

    public TurbineControllerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf networkData) {
        this(windowId, playerInventory, (TurbineControllerEntity)AbstractModBlockEntity.getGuiClientBlockEntity((FriendlyByteBuf)networkData));
    }

    public EnergySystem getOutputEnergySystem() {
        return this._outputEnergySystem;
    }

    public WideAmount getEnergyCapacity() {
        return this._energyCapacity;
    }

    public int getFluidCapacity() {
        return this._fluidCapacity;
    }

    public int getRotorBladesCount() {
        return this._rotorBladesCount;
    }

    public int getBaseFluidPerBlade() {
        return this._baseFluidPerBlade;
    }

    public int getMaxIntakeRateHardLimit() {
        return this._maxIntakeRateHardLimit;
    }

    public int getMaxIntakeRate() {
        return this._maxIntakeRate;
    }

    public float getMaxRotorSpeed() {
        return this._maxRotorSpeed;
    }
}

