/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.multiblock.CuboidMultiblockStateDataProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public abstract class AbstractMultiblockModelsDataProvider
extends CuboidMultiblockStateDataProvider {
    private final ResourceLocation _transparentBlockModel = this.blocksRoot().buildWithSuffix("transparentblock");

    protected AbstractMultiblockModelsDataProvider(String name, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ResourceLocationBuilder modLocationRoot) {
        super(name, output, lookupProvider, modLocationRoot);
    }

    protected ResourceLocationBuilder reactorRoot() {
        return this.blocksRoot().appendPath(new String[]{"reactor"});
    }

    protected ResourceLocationBuilder turbineRoot() {
        return this.blocksRoot().appendPath(new String[]{"turbine"});
    }

    protected ResourceLocation transparentBlockModel() {
        return this._transparentBlockModel;
    }

    protected ResourceLocation genericPartModel(String modelName, String textureName, String subFolder) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)modelName) ? 1 : 0) != 0, (Object)"Model name must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)textureName) ? 1 : 0) != 0, (Object)"Texture name must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subFolder) ? 1 : 0) != 0, (Object)"Sub folder name must not be null or empty");
        ResourceLocationBuilder idBuilder = this.blocksRoot().appendPath(new String[]{subFolder});
        return this.models().model(idBuilder.buildWithSuffix(modelName)).cube(idBuilder.buildWithSuffix(textureName));
    }

    protected ResourceLocation genericPartModel(String name, String subFolder) {
        return this.genericPartModel(name, name, subFolder);
    }

    protected ResourceLocation assembledPlatingModel(String modelName, String textureName, String subFolder) {
        return this.genericPartModel(modelName, textureName, subFolder);
    }

    protected ResourceLocation assembledPlatingModel(String subFolder) {
        return this.assembledPlatingModel("assembledplating", "plating", subFolder);
    }

    protected <B extends Block> void genericPart(Supplier<B> block, String name, String subFolder, String ... subModelSuffixes) {
        ResourceLocation mainModel = this.genericPartModel(name, subFolder);
        this.singleVariant(block).model(mainModel);
        this.models().item(block).parent(mainModel).build();
        for (String suffix : subModelSuffixes) {
            this.genericPartModel(name + suffix, subFolder);
        }
    }

    protected <B extends Block> void controller(Supplier<B> block, String subFolder) {
        this.genericPart(block, "controller", subFolder, "_on", "_off");
    }

    protected <B extends Block> void redstonePort(Supplier<B> block, String subFolder) {
        this.genericPart(block, "redstoneport", subFolder, "_on");
    }

    protected <B extends Block> void ioPort(Supplier<B> block, String name, String subFolder, String inputSuffix, String outputSuffix) {
        this.genericPart(block, name + "_" + inputSuffix, subFolder, new String[0]);
        this.genericPartModel(name + "_assembled_" + inputSuffix, subFolder);
        this.genericPartModel(name + "_assembled_" + inputSuffix + "_connected", subFolder);
        this.genericPartModel(name + "_assembled_" + outputSuffix, subFolder);
        this.genericPartModel(name + "_assembled_" + outputSuffix + "_connected", subFolder);
    }

    protected <B extends Block> void ioPort(Supplier<B> block, String name, String subFolder) {
        this.ioPort(block, name, subFolder, "input", "output");
    }

    protected <B extends Block> void powerPort(Supplier<B> block, String name, String subFolder) {
        this.ioPort(block, name, subFolder);
    }

    protected <B extends Block> void fluidPort(Supplier<B> block, String name, String subFolder) {
        this.genericPart(block, name + "_cold", subFolder, new String[0]);
        this.genericPartModel(name + "_cold_connected", subFolder);
        this.genericPartModel(name + "_hot", subFolder);
        this.genericPartModel(name + "_hot_connected", subFolder);
    }

    protected <B extends Block> void computerPort(Supplier<? extends Block> block, String subFolder) {
        this.genericPart(block, "computerport", subFolder, "_connected");
    }
}

