/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import shetiphian.core.common.CapabilityHelper;
import shetiphian.core.common.Function;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.misc.CauldronHelper;
import shetiphian.endertanks.modintegration.handlers.WrapperFluidHandler;

public class TypeFluid {
    public static void init() {
        HandlerRegistry.register(ForgeCapabilities.FLUID_HANDLER, new FluidTankHandler.Provider());
    }

    public static class FluidTankHandler
    implements ITankHandler<IFluidHandler> {
        private final FluidTank fluidTank;
        private final IFluidHandler fluidTankInsertOnly;
        private final IFluidHandler fluidTankExtractOnly;

        public FluidTankHandler(final IEnderTankInfo tank) {
            this.fluidTank = new FluidTank(tank.getCapacity() * 1000){

                public void setFluid(FluidStack fluid) {
                    if (!Function.areFluidStacksEqual((FluidStack)this.getFluid(), (FluidStack)fluid)) {
                        super.setFluid(fluid);
                        this.onContentsChanged();
                    }
                }

                public FluidTank setCapacity(int capacity) {
                    if (this.getCapacity() != capacity) {
                        super.setCapacity(capacity);
                        this.onContentsChanged();
                    }
                    return this;
                }

                protected void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.fluidTankInsertOnly = new WrapperFluidHandler((IFluidHandler)this.fluidTank, true, false);
            this.fluidTankExtractOnly = new WrapperFluidHandler((IFluidHandler)this.fluidTank, false, true);
        }

        @Override
        public IFluidHandler getTank(StorageAccessMode access) {
            return switch (access) {
                case StorageAccessMode.INSERT_ONLY -> this.fluidTankInsertOnly;
                case StorageAccessMode.EXTRACT_ONLY -> this.fluidTankExtractOnly;
                default -> this.fluidTank;
            };
        }

        @Override
        public void setCapacity(int capacity) {
            this.fluidTank.setCapacity(capacity * 1000);
        }

        @Override
        public void load(CompoundTag nbt) {
            this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt));
        }

        @Override
        public CompoundTag save() {
            return this.fluidTank.getFluidAmount() > 0 ? this.fluidTank.writeToNBT(new CompoundTag()) : null;
        }

        @Override
        public MutableComponent getContentsInfo() {
            FluidStack stack = this.fluidTank.getFluid();
            if (!stack.isEmpty()) {
                return Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.type.fluid")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)stack.getTranslationKey())).m_130946_(" [" + (float)stack.getAmount() / 1000.0f + "K/" + this.fluidTank.getCapacity() / 1000 + "K mB]");
            }
            return null;
        }

        @Override
        public void preformPumpAction(Level world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, int pumpCapacity, RandomSource random) {
            int used;
            FluidStack fluidStack;
            if (this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
                IFluidHandler fromHandler = CapabilityHelper.FLUIDS.getHandler(world.m_7702_(pullFromPos), facing);
                if (fromHandler != null) {
                    fluidStack = fromHandler.drain(pumpCapacity, IFluidHandler.FluidAction.SIMULATE);
                    used = this.fluidTank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                    if (used > 0) {
                        this.fluidTank.fill(fromHandler.drain(used, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    BlockState fromState = world.m_8055_(pullFromPos);
                    if (fromState.m_60734_() instanceof AbstractCauldronBlock) {
                        CauldronHelper.drainCauldron(fromState, world, pullFromPos, (IFluidHandler)this.fluidTank);
                    }
                }
            }
            if (!this.fluidTank.isEmpty()) {
                IFluidHandler toHandler = CapabilityHelper.FLUIDS.getHandler(world.m_7702_(pushToPos), facing.m_122424_());
                if (toHandler != null) {
                    fluidStack = this.fluidTank.drain(pumpCapacity, IFluidHandler.FluidAction.SIMULATE);
                    used = toHandler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                    if (used > 0) {
                        toHandler.fill(this.fluidTank.drain(used, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    BlockState toState = world.m_8055_(pushToPos);
                    if (toState.m_60734_() instanceof AbstractCauldronBlock) {
                        CauldronHelper.fillCauldron(toState, world, pushToPos, (IFluidHandler)this.fluidTank);
                    }
                }
            }
        }

        @Override
        public int getComparatorOutput() {
            long amount = this.fluidTank.getFluid().getAmount();
            float fill = (float)amount / (float)this.fluidTank.getCapacity();
            return Mth.m_14143_((float)(fill * 14.0f)) + (amount > 0L ? 1 : 0);
        }

        @Override
        public Component getDisplayName() {
            return Component.m_237115_((String)"info.endertanks.tank.type.fluid");
        }

        public static class Provider
        implements HandlerRegistry.ITankHandlerProvider<IFluidHandler> {
            @Override
            public ITankHandler<IFluidHandler> create(IEnderTankInfo tank) {
                return new FluidTankHandler(tank);
            }
        }
    }
}

