/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public final class FluidHelper {
    public static FluidStack getFluidFromStack(ItemStack stack) {
        return FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41783_());
    }

    public static Rarity getFluidRarity(FluidStack fluid) {
        return fluid.getFluid().getFluidType().getRarity();
    }

    public static int getFluidAmount(ItemStack stack) {
        FluidStack fluid = FluidHelper.getFluidFromStack(stack);
        return fluid == null ? 0 : fluid.getAmount();
    }

    public static ItemStack getFilledBucket(FluidStack fluid, Item bucket, int capacity) {
        if (ForgeRegistries.FLUIDS.containsValue((Object)fluid.getFluid())) {
            ItemStack filledBucket = new ItemStack((ItemLike)bucket);
            FluidStack fluidContents = new FluidStack(fluid, capacity);
            CompoundTag tag = new CompoundTag();
            fluidContents.writeToNBT(tag);
            filledBucket.m_41751_(tag);
            return filledBucket;
        }
        return ItemStack.f_41583_;
    }

    public static int toBuckets(int i) {
        return i - i % 1000;
    }
}

