/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.crafting.OutputResolver;
import com.blakebr0.cucumber.crafting.recipe.ShapedNoMirrorRecipe;
import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class ShapedTagRecipe
extends ShapedNoMirrorRecipe {
    private final OutputResolver outputResolver;
    private ItemStack output;

    public ShapedTagRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> inputs, OutputResolver.Item outputResolver, boolean showNotification) {
        super(id, group, category, width, height, inputs, ItemStack.f_41583_, showNotification);
        this.outputResolver = outputResolver;
    }

    public ShapedTagRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> inputs, String tag, int count, boolean showNotification) {
        super(id, group, category, width, height, inputs, ItemStack.f_41583_, showNotification);
        this.outputResolver = new OutputResolver.Tag(tag, count);
    }

    public ItemStack m_8043_(RegistryAccess access) {
        if (this.output == null) {
            this.output = this.outputResolver.resolve();
        }
        return this.output;
    }

    public boolean m_5598_() {
        if (this.output == null) {
            this.output = this.outputResolver.resolve();
        }
        return this.output.m_41619_();
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_SHAPED_TAG.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedTagRecipe> {
        public ShapedTagRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map key = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern"));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList ingredients = ShapedRecipe.m_44202_((String[])pattern, (Map)key, (int)width, (int)height);
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            String tag = GsonHelper.m_13906_((JsonObject)result, (String)"tag");
            int count = GsonHelper.m_13824_((JsonObject)result, (String)"count", (int)1);
            boolean showNotification = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
            return new ShapedTagRecipe(recipeId, group, category, width, height, (NonNullList<Ingredient>)ingredients, tag, count, showNotification);
        }

        public ShapedTagRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            OutputResolver.Item output = OutputResolver.create(buffer);
            boolean showNotification = buffer.readBoolean();
            return new ShapedTagRecipe(recipeId, group, category, width, height, (NonNullList<Ingredient>)ingredients, output, showNotification);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedTagRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeItemStack(recipe.outputResolver.resolve(), false);
            buffer.writeBoolean(recipe.m_271738_());
        }
    }
}

