/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.packet;

import java.util.function.Supplier;
import net.gigabit101.rebornstorage.blockentities.BlockEntityMultiCrafter;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketMultiblockUpdate {
    private final BlockPos blockPos;
    private final boolean assembled;

    public PacketMultiblockUpdate(BlockPos blockPos, boolean assembled) {
        this.blockPos = blockPos;
        this.assembled = assembled;
    }

    public static void encode(PacketMultiblockUpdate packetGui, FriendlyByteBuf buf) {
        buf.m_130064_(packetGui.blockPos);
        buf.writeBoolean(packetGui.assembled);
    }

    public static PacketMultiblockUpdate decode(FriendlyByteBuf buf) {
        return new PacketMultiblockUpdate(buf.m_130135_(), buf.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketMultiblockUpdate message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                BlockEntity blockEntity = player.m_9236_().m_7702_(message.blockPos);
                if (blockEntity != null && blockEntity instanceof BlockEntityMultiCrafter) {
                    BlockEntityMultiCrafter blockEntityMultiCrafter = (BlockEntityMultiCrafter)blockEntity;
                    blockEntityMultiCrafter.getMultiBlock().setAssembled(message.assembled);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

