/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.utils;

import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.AthenaUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public record CtmState(boolean up, boolean down, boolean left, boolean right, boolean upLeft, boolean upRight, boolean downLeft, boolean downRight) {
    public static CtmState from(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction, ConnectionCheck check) {
        BlockPos upPos = AthenaUtils.getFacingPos(pos, direction, AthenaUtils.UrMom.UP);
        BlockPos downPos = AthenaUtils.getFacingPos(pos, direction, AthenaUtils.UrMom.DOWN);
        boolean up = ConnectionCheck.test(check, level, state, pos, upPos, direction);
        boolean down = ConnectionCheck.test(check, level, state, pos, downPos, direction);
        boolean left = ConnectionCheck.test(check, level, state, pos, AthenaUtils.getFacingPos(pos, direction, AthenaUtils.UrMom.LEFT), direction);
        boolean right = ConnectionCheck.test(check, level, state, pos, AthenaUtils.getFacingPos(pos, direction, AthenaUtils.UrMom.RIGHT), direction);
        boolean upLeft = ConnectionCheck.test(check, level, state, pos, AthenaUtils.getFacingPos(upPos, direction, AthenaUtils.UrMom.LEFT), direction);
        boolean upRight = ConnectionCheck.test(check, level, state, pos, AthenaUtils.getFacingPos(upPos, direction, AthenaUtils.UrMom.RIGHT), direction);
        boolean downLeft = ConnectionCheck.test(check, level, state, pos, AthenaUtils.getFacingPos(downPos, direction, AthenaUtils.UrMom.LEFT), direction);
        boolean downRight = ConnectionCheck.test(check, level, state, pos, AthenaUtils.getFacingPos(downPos, direction, AthenaUtils.UrMom.RIGHT), direction);
        return new CtmState(up, down, left, right, upLeft, upRight, downLeft, downRight);
    }

    public boolean allTrue() {
        return this.up && this.down && this.right && this.left && this.upRight && this.upLeft && this.downRight && this.downLeft;
    }

    @FunctionalInterface
    public static interface ConnectionCheck {
        public boolean test(BlockPos var1, BlockState var2, BlockState var3);

        public static boolean test(ConnectionCheck check, AppearanceAndTintGetter level, BlockState fromState, BlockPos fromPos, BlockPos pos, Direction direction) {
            AppearanceAndTintGetter.Query query = level.query(pos, direction, fromState, fromPos);
            if (query.appearance().m_60795_()) {
                return false;
            }
            return check.test(pos, query.state(), query.appearance());
        }
    }
}

