/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.forge;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.mixins.forge.FireBlockAccessor;
import net.mehvahdjukaar.supplementaries.mixins.forge.MobBucketItemAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppPlatformStuffImpl {
    public static EntityType<?> getFishType(MobBucketItem bucketItem) {
        return ((MobBucketItemAccessor)bucketItem).invokeGetFishType();
    }

    @Nullable
    public static <T> T getForgeCap(Object object, Class<T> capClass) {
        Capability<T> t = CapabilityHandler.getToken(capClass);
        if (t != null && object instanceof ICapabilityProvider) {
            ICapabilityProvider cp = (ICapabilityProvider)object;
            return CapabilityHandler.get(cp, t);
        }
        return null;
    }

    @Nullable
    public static BlockState getUnoxidised(Level level, BlockPos pos, BlockState state) {
        BlockState newMod;
        Player fp = FakePlayerManager.getDefault((Level)level);
        fp.m_21008_(InteractionHand.MAIN_HAND, Items.f_42386_.m_7968_());
        Block b = state.m_60734_();
        UseOnContext context = new UseOnContext(fp, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, false));
        BlockState modified = state;
        modified = b.getToolModifiedState(modified, context, ToolActions.AXE_WAX_OFF, false);
        if (modified == null) {
            modified = state;
        }
        while ((newMod = b.getToolModifiedState(modified, context, ToolActions.AXE_SCRAPE, false)) != null && newMod != modified) {
            modified = newMod;
        }
        if (modified == state) {
            return null;
        }
        return modified;
    }

    public static boolean isEndermanMask(@NotNull EnderMan enderMan, Player player, ItemStack itemstack) {
        try {
            return itemstack.isEnderMask(player, enderMan);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getItemLifeSpawn(ItemEntity itemEntity) {
        return itemEntity.lifespan;
    }

    public static void onItemPickup(Player player, ItemEntity itemEntity, ItemStack copy) {
        ForgeEventFactory.firePlayerItemPickupEvent((Player)player, (ItemEntity)itemEntity, (ItemStack)copy);
    }

    public static CreativeModeTab.Builder searchBar(CreativeModeTab.Builder c) {
        return c.withSearchBar();
    }

    public static float getDownfall(Biome biome) {
        return biome.getModifiedClimateSettings().f_47683_();
    }

    public static void disableAMWarn() {
        ((ForgeConfigSpec.BooleanValue)ClientConfigs.General.NO_AMENDMENTS_WARN).set((Object)true);
    }

    public static void disableIMWarn() {
        ((ForgeConfigSpec.BooleanValue)ClientConfigs.General.NO_INCOMPATIBLE_MODS).set((Object)true);
    }

    public static void disableOFWarn(boolean on) {
        ((ForgeConfigSpec.BooleanValue)ClientConfigs.General.NO_OPTIFINE_WARN).set((Object)on);
    }

    public static boolean canStickTo(BlockState movedState, BlockState blockState) {
        return movedState.canStickTo(blockState);
    }

    public static SlotReference getFirstInInventory(LivingEntity entity, Predicate<ItemStack> predicate) {
        IItemHandler cap = (IItemHandler)CapabilityHandler.get((ICapabilityProvider)entity, ForgeCapabilities.ITEM_HANDLER);
        if (cap != null) {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack quiver = cap.getStackInSlot(i);
                if (!predicate.test(quiver)) continue;
                return new CapSlotReference(i);
            }
        }
        return SlotReference.EMPTY;
    }

    public static FoodProperties getFoodProperties(ItemStack selected, LivingEntity entity) {
        return selected.getFoodProperties(entity);
    }

    public static SoundType getSoundType(BlockState blockState, BlockPos pos, Level level, Entity entity) {
        return blockState.getSoundType((LevelReader)level, pos, entity);
    }

    public static void setParticlePos(BlockParticleOption blockParticleOption, BlockPos pos) {
        blockParticleOption.setPos(pos);
    }

    public static boolean isSlimeball(Item item) {
        return item.m_204114_().m_203656_(Tags.Items.SLIMEBALLS);
    }

    public static boolean canCatchFire(Level level, BlockPos below, Direction direction) {
        return ((FireBlock)Blocks.f_50083_).canCatchFire((BlockGetter)level, below, direction);
    }

    public static void tryBurningByFire(ServerLevel level, BlockPos pos, int chance, RandomSource random, int age, Direction direction) {
        ((FireBlockAccessor)Blocks.f_50083_).invokeTryCatchFire((Level)level, pos, chance, random, age, direction);
    }

    public static InteractionResultHolder<ItemStack> fireItemUseEvent(Player player, InteractionHand hand) {
        InteractionResult r = ForgeHooks.onItemRightClick((Player)player, (InteractionHand)hand);
        if (r == null) {
            r = InteractionResult.PASS;
        }
        return new InteractionResultHolder(r, (Object)player.m_21120_(hand));
    }

    public static void dispenseContent(DispensibleContainerItem dc, ItemStack stack, BlockHitResult hit, Level level, @Nullable Player player) {
        dc.emptyContents(player, level, hit.m_82425_(), hit, stack);
    }

    static {
        SlotReference.REGISTRY.register("cap_slot", CapSlotReference.CODEC);
    }

    public record CapSlotReference(int slot) implements SlotReference
    {
        public static final Codec<CapSlotReference> CODEC = Codec.INT.xmap(CapSlotReference::new, CapSlotReference::slot);

        @Override
        public ItemStack get(LivingEntity player) {
            LazyOptional cap = player.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (cap.isPresent()) {
                return ((IItemHandler)cap.orElse(null)).getStackInSlot(this.slot);
            }
            return null;
        }

        @Override
        public Codec<? extends SlotReference> getCodec() {
            return CODEC;
        }
    }
}

