/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BuntingBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BuntingItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RopeBuntingBlock
extends AbstractRopeBlock
implements EntityBlock,
IRotatable,
IWashable {
    public static final EnumProperty<ModBlockProperties.Bunting> NORTH = ModBlockProperties.NORTH_BUNTING;
    public static final EnumProperty<ModBlockProperties.Bunting> SOUTH = ModBlockProperties.SOUTH_BUNTING;
    public static final EnumProperty<ModBlockProperties.Bunting> WEST = ModBlockProperties.WEST_BUNTING;
    public static final EnumProperty<ModBlockProperties.Bunting> EAST = ModBlockProperties.EAST_BUNTING;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final Map<Direction, EnumProperty<ModBlockProperties.Bunting>> HORIZONTAL_FACING_TO_PROPERTY_MAP = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
    });
    public final Map<BlockState, BlockState> buntingToRope = new Object2ObjectOpenHashMap();

    public RopeBuntingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        UnmodifiableIterator unmodifiableIterator = this.f_49792_.m_61056_().iterator();
        while (unmodifiableIterator.hasNext()) {
            BlockState state;
            BlockState state1 = state = (BlockState)unmodifiableIterator.next();
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                state1 = this.setConnection(dir, state1, this.hasConnection(dir, state1));
            }
            this.buntingToRope.put(state, state1);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Override
    protected Map<BlockState, VoxelShape> makeShapes() {
        HashMap<BlockState, VoxelShape> shapes = new HashMap<BlockState, VoxelShape>();
        VoxelShape down = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape up = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.m_49796_((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape south = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        VoxelShape west = Block.m_49796_((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape east = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        VoxelShape knot = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape northBunting = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)10.0, (double)8.0);
        VoxelShape southBunting = Block.m_49796_((double)7.0, (double)0.0, (double)8.0, (double)9.0, (double)10.0, (double)16.0);
        VoxelShape westBunting = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)8.0, (double)10.0, (double)9.0);
        VoxelShape eastBunting = Block.m_49796_((double)8.0, (double)0.0, (double)7.0, (double)16.0, (double)10.0, (double)9.0);
        for (BlockState state : this.f_49792_.m_61056_()) {
            ModBlockProperties.Bunting e;
            ModBlockProperties.Bunting w;
            ModBlockProperties.Bunting s;
            ModBlockProperties.Bunting n;
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) continue;
            VoxelShape v = Shapes.m_83040_();
            if (((Boolean)state.m_61143_((Property)KNOT)).booleanValue()) {
                v = Shapes.m_83124_((VoxelShape)knot, (VoxelShape[])new VoxelShape[0]);
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)down);
            }
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)up);
            }
            if ((n = (ModBlockProperties.Bunting)((Object)state.m_61143_(NORTH))).isConnected()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)north);
            }
            if (n.hasBunting()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)northBunting);
            }
            if ((s = (ModBlockProperties.Bunting)((Object)state.m_61143_(SOUTH))).isConnected()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)south);
            }
            if (s.hasBunting()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)southBunting);
            }
            if ((w = (ModBlockProperties.Bunting)((Object)state.m_61143_(WEST))).isConnected()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)west);
            }
            if (w.hasBunting()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)westBunting);
            }
            if ((e = (ModBlockProperties.Bunting)((Object)state.m_61143_(EAST))).isConnected()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)east);
            }
            if (e.hasBunting()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)eastBunting);
            }
            v = v.m_83296_();
            boolean flag = true;
            for (VoxelShape existing : shapes.values()) {
                if (!existing.equals(v)) continue;
                shapes.put(state, existing);
                flag = false;
                break;
            }
            if (!flag) continue;
            shapes.put(state, v);
        }
        return new Object2ObjectOpenHashMap(shapes);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ItemDisplayTile) {
                ItemDisplayTile tile = (ItemDisplayTile)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tile);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Override
    public boolean hasConnection(Direction dir, BlockState state) {
        if (dir == Direction.DOWN) {
            return (Boolean)state.m_61143_((Property)DOWN);
        }
        if (dir == Direction.UP) {
            return (Boolean)state.m_61143_((Property)UP);
        }
        return ((ModBlockProperties.Bunting)((Object)state.m_61143_((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir)))).isConnected();
    }

    @Override
    public BlockState setConnection(Direction dir, BlockState state, boolean value) {
        if (dir == Direction.DOWN) {
            return (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(value));
        }
        if (dir == Direction.UP) {
            return (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(value));
        }
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir), (Comparable)((Object)(value ? ModBlockProperties.Bunting.ROPE : ModBlockProperties.Bunting.NONE)));
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return Optional.of(state);
    }

    public Optional<Direction> rotateOverAxis(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        BlockEntity blockEntity;
        if (axis.m_122434_() == Direction.Axis.Y && (blockEntity = level.m_7702_(pos)) instanceof BuntingBlockTile) {
            BuntingBlockTile tile = (BuntingBlockTile)blockEntity;
            HashMap<Direction, ItemStack> newMap = new HashMap<Direction, ItemStack>();
            for (Direction dir2 : Direction.Plane.HORIZONTAL) {
                ItemStack stack2 = tile.m_8020_(dir2.m_122416_());
                if (stack2.m_41619_()) continue;
                Direction newDir = rotation.m_55954_(dir2);
                if (RopeBuntingBlock.canSupportBunting(state, newDir.m_122416_())) {
                    newMap.put(newDir, stack2);
                    continue;
                }
                return Optional.empty();
            }
            if (!newMap.isEmpty()) {
                tile.m_6211_();
                newMap.forEach((dir, stack) -> tile.m_6836_(dir.m_122416_(), (ItemStack)stack));
                return Optional.of(axis);
            }
        }
        return Optional.empty();
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return super.m_6843_(state, rotation);
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return super.m_6943_(state, mirror);
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return super.m_5939_(this.buntingToRope.get(state), worldIn, pos, context);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BuntingBlockTile(pos, state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Optional<Direction> closest;
        BuntingBlockTile tile;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BuntingBlockTile && (tile = (BuntingBlockTile)blockEntity).isAccessibleBy(player) && (closest = RopeBuntingBlock.findClosestConnection(state, pos, hit.m_82450_())).isPresent()) {
            return tile.interact(player, handIn, closest.get().m_122416_());
        }
        return InteractionResult.PASS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        Optional<Direction> closest = RopeBuntingBlock.findClosestConnection(state, pos, target.m_82450_());
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BuntingBlockTile) {
            ItemStack held;
            BuntingBlockTile tile = (BuntingBlockTile)blockEntity;
            if (closest.isPresent() && !(held = tile.m_8020_(closest.get().m_122416_())).m_41619_()) {
                return held.m_41777_();
            }
        }
        return this.m_7397_(world, pos, state);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return ModRegistry.ROPE_ITEM.get().m_7968_();
    }

    private static Optional<Direction> findClosestConnection(BlockState state, BlockPos pos, Vec3 hit) {
        Vector3f hitPos = hit.m_82492_((double)pos.m_123341_() + 0.5, 0.0, (double)pos.m_123343_() + 0.5).m_252839_();
        List<Direction> availableDir = Direction.Plane.HORIZONTAL.m_122557_().filter(dir -> ((AbstractRopeBlock)state.m_60734_()).hasConnection((Direction)dir, state)).toList();
        return availableDir.stream().min((a, b) -> {
            Vector3f v1 = a.m_253071_();
            Vector3f v2 = b.m_253071_();
            float d1 = v1.distanceSquared((Vector3fc)hitPos);
            float d2 = v2.distanceSquared((Vector3fc)hitPos);
            return Float.compare(d1, d2);
        });
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockEntity blockEntity;
        BlockState newState = super.m_7417_(stateIn, facing, facingState, level, pos, facingPos);
        if (facing.m_122434_().m_122479_() && this.hasConnection(facing, stateIn) && (blockEntity = level.m_7702_(pos)) instanceof BuntingBlockTile) {
            BuntingBlockTile tile = (BuntingBlockTile)blockEntity;
            int index = facing.m_122416_();
            ItemStack item = tile.m_8020_(index);
            if (!item.m_41619_()) {
                if (!RopeBuntingBlock.canSupportBunting(newState, index)) {
                    if (level instanceof Level) {
                        Level l = (Level)level;
                        this.popItem(l, pos, item, facing);
                    }
                    tile.m_6836_(index, ItemStack.f_41583_);
                    newState = (BlockState)newState.m_61124_((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(facing), (Comparable)((Object)ModBlockProperties.Bunting.NONE));
                } else {
                    newState = (BlockState)newState.m_61124_((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(facing), (Comparable)((Object)ModBlockProperties.Bunting.BUNTING));
                }
            }
            if (tile.m_7983_()) {
                newState = RopeBuntingBlock.toRope(newState);
            }
        }
        return newState;
    }

    public void popItem(Level level, BlockPos pos, ItemStack stack, Direction dir) {
        if (!level.f_46443_ && !stack.m_41619_() && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            double h = (double)EntityType.f_20461_.m_20679_() / 2.0 + 0.25;
            Vector3f step = dir.m_253071_().mul(0.25f);
            double x = (double)(step.x + (float)pos.m_123341_()) + 0.5;
            double y = (double)(step.y + (float)pos.m_123342_()) + 0.5 - h;
            double z = (double)(step.z + (float)pos.m_123343_()) + 0.5;
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, stack.m_41777_());
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
    }

    public static boolean canSupportBunting(BlockState state, int index) {
        Direction dir = Direction.m_122407_((int)index);
        return ((ModBlockProperties.Bunting)((Object)state.m_61143_((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir)))).isConnected();
    }

    @Nullable
    public static BlockState fromRope(BlockState state, BlockHitResult hit) {
        BlockState s = RopeBuntingBlock.fromRope(state);
        Optional<Direction> closest = RopeBuntingBlock.findClosestConnection(state, hit.m_82425_(), hit.m_82450_());
        return closest.map(direction -> (BlockState)s.m_61124_((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(direction), (Comparable)((Object)ModBlockProperties.Bunting.BUNTING))).orElse(null);
    }

    public static BlockState fromRope(BlockState state) {
        RopeBuntingBlock block = ModRegistry.BUNTING_BLOCK.get();
        BlockState s = block.m_152465_(state);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            s = block.setConnection(dir, s, ((RopeBlock)state.m_60734_()).hasConnection(dir, state));
        }
        return s;
    }

    public static BlockState toRope(BlockState state) {
        RopeBlock block = ModRegistry.ROPE.get();
        BlockState s = block.m_152465_(state);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            s = block.setConnection(dir, s, ((RopeBuntingBlock)state.m_60734_()).hasConnection(dir, state));
        }
        return s;
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        Optional<Direction> closest = RopeBuntingBlock.findClosestConnection(state, pos, hitVec);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BuntingBlockTile) {
            ItemStack held;
            BuntingBlockTile tile = (BuntingBlockTile)blockEntity;
            if (closest.isPresent() && !(held = tile.m_8020_(closest.get().m_122416_())).m_41619_() && BuntingItem.getColor(held) != DyeColor.WHITE) {
                BuntingItem.setColor(held, DyeColor.WHITE);
                tile.m_6836_(closest.get().m_122416_(), held);
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
                return true;
            }
        }
        return false;
    }
}

