/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.AlternativeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SlingshotBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class CannonBlock
extends DirectionalBlock
implements EntityBlock,
ILightable,
IRotatable {
    private static final Map<Item, IFireItemBehavior> FIRE_BEHAVIORS = new Object2ObjectOpenHashMap();
    private static final IFireItemBehavior DEFAULT = new AlternativeBehavior(new GenericProjectileBehavior(), new SlingshotBehavior());
    protected static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public CannonBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void registerBehavior(ItemLike pItem, IFireItemBehavior pBehavior) {
        FIRE_BEHAVIORS.put(pItem.m_5456_(), pBehavior);
    }

    public static IFireItemBehavior getCannonBehavior(ItemLike item) {
        return FIRE_BEHAVIORS.getOrDefault(item, DEFAULT);
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_5871_(itemStack, blockGetter, list, tooltipFlag);
        if (!MiscUtils.showsHints(blockGetter, tooltipFlag)) {
            return;
        }
        list.add((Component)Component.m_237115_((String)"message.supplementaries.cannon").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            return tile;
        }
        return null;
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_52588_, POWERED});
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_43719_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        if (placer != null && (blockEntity = level.m_7702_(pos)) instanceof CannonBlockTile) {
            CannonBlockTile cannon = (CannonBlockTile)blockEntity;
            Direction dir = Direction.m_122382_((Entity)placer)[0];
            Direction myDir = ((Direction)state.m_61143_((Property)f_52588_)).m_122424_();
            if (dir.m_122434_() == Direction.Axis.Y) {
                float pitch = dir == Direction.UP ? -90.0f : 90.0f;
                cannon.setRestrainedPitch(myDir.m_122424_() == dir ? pitch + 180.0f : pitch);
            } else {
                float yaw = dir.m_122435_();
                cannon.setRestrainedYaw(myDir.m_122424_() == dir ? yaw + 180.0f : yaw);
            }
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean wasPowered;
        if (!level.f_46443_ && (wasPowered = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != level.m_276867_(pos)) {
            BlockEntity blockEntity;
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
            if (!wasPowered && (blockEntity = level.m_7702_(pos)) instanceof CannonBlockTile) {
                CannonBlockTile tile = (CannonBlockTile)blockEntity;
                tile.ignite(null);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CannonBlockTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.CANNON_TILE.get(), CannonBlockTile::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult litUpAction = this.interactWithPlayer(state, level, pos, player, hand);
        if (litUpAction != InteractionResult.PASS) {
            return litUpAction;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                tile.tryOpeningEditGui(sp, pos, player.m_21120_(hand));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CannonBlockTile) {
                CannonBlockTile tile = (CannonBlockTile)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tile);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            return tile.isFiring();
        }
        return false;
    }

    public boolean lightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSourceType fireSourceType) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            if (tile.readyToFire()) {
                if (!world.m_5776_()) {
                    tile.ignite(player);
                    this.playLightUpSound(world, pos, fireSourceType);
                }
                world.m_142346_(player, GameEvent.f_157792_, pos);
                return true;
            }
            return false;
        }
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return switch (((Direction)state.m_61143_((Property)f_52588_)).m_122424_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return super.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ec = (EntityCollisionContext)context;
            Entity entity = ec.m_193113_();
            if (entity instanceof Projectile) {
                Projectile p = (Projectile)entity;
                if (p.f_19797_ < 10) {
                    return Shapes.m_83040_();
                }
            }
            if (ec.m_193113_() != null) {
                return super.m_5939_(state, level, pos, context);
            }
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_52588_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        System.out.println("Event " + id + "_ " + level.m_5776_() + " " + level.m_46467_());
        if (id > 1) {
            return false;
        }
        if (!level.f_46443_) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            float yaw = tile.getYaw();
            float pitch = tile.getPitch();
            PoseStack poseStack = new PoseStack();
            poseStack.m_252880_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f + 0.0625f, (float)pos.m_123343_() + 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
            poseStack.m_85837_(0.0, 0.0, -1.4);
            if (id == 1) {
                this.playFiringEffects(pos, level, poseStack, pitch, yaw, tile.getPowerLevel());
            } else {
                CannonBlock.playIgniteEffects(pos, level, poseStack);
            }
        }
        return false;
    }

    private static void playIgniteEffects(BlockPos pos, Level level, PoseStack poseStack) {
        Vector4f p = poseStack.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, 1.75f, 1.0f));
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)p.x, (double)p.y, (double)p.z, 0.0, 0.0, 0.0);
        level.m_245747_(pos, ModSounds.CANNON_IGNITE.get(), SoundSource.BLOCKS, 0.6f, 1.2f + level.m_213780_().m_188501_() * 0.2f, false);
    }

    private void playFiringEffects(BlockPos pos, Level level, PoseStack poseStack, float pitch, float yaw, int power) {
        level.m_7106_((ParticleOptions)ModParticles.CANNON_FIRE_PARTICLE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(pitch * ((float)Math.PI / 180)), (double)(-yaw * ((float)Math.PI / 180)), 0.0);
        RandomSource ran = level.f_46441_;
        this.spawnDustRing(level, poseStack);
        this.spawnSmokeTrail(level, poseStack, ran);
        float soundPitch = 1.3f - (float)power * 0.1f;
        float soundVolume = 2.0f + (float)power * 0.6f;
        level.m_245747_(pos, ModSounds.CANNON_FIRE.get(), SoundSource.BLOCKS, soundVolume, soundPitch, false);
    }

    private void spawnSmokeTrail(Level level, PoseStack poseStack, RandomSource ran) {
        int smokeCount = 40;
        for (int i = 0; i < smokeCount; ++i) {
            poseStack.m_85836_();
            Vector4f speed = poseStack.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, -MthUtils.nextWeighted((RandomSource)ran, (float)0.5f, (float)1.0f, (float)0.06f), 0.0f));
            float aperture = 0.5f;
            poseStack.m_252880_(-aperture / 2.0f + ran.m_188501_() * aperture, -aperture / 2.0f + ran.m_188501_() * aperture, 0.0f);
            Vector4f p = poseStack.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.m_85849_();
        }
    }

    private void spawnDustRing(Level level, PoseStack poseStack) {
        poseStack.m_85836_();
        Vector4f p = poseStack.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
        int dustCount = 16;
        for (int i = 0; i < dustCount; ++i) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(380.0f * (float)i / (float)dustCount));
            Vector4f speed = poseStack.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, 0.05f, 0.0f));
            level.m_7106_((ParticleOptions)ModParticles.BOMB_SMOKE_PARTICLE.get(), (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor levelAccessor, BlockPos blockPos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        boolean ccw = rotation == Rotation.COUNTERCLOCKWISE_90;
        return BlockUtil.getRotatedDirectionalBlock(state, axis, ccw).or(() -> Optional.of(state));
    }

    public void onRotated(BlockState newState, BlockState oldState, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        BlockEntity blockEntity;
        if (axis.m_122434_() == ((Direction)newState.m_61143_((Property)f_52588_)).m_122434_() && (blockEntity = world.m_7702_(pos)) instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            float angle = rotation.m_55949_(0, 4) * -90;
            Vector3f currentDir = Vec3.m_82498_((float)tile.getPitch(), (float)tile.getYaw()).m_252839_();
            Quaternionf q = new Quaternionf().rotateAxis(angle * ((float)Math.PI / 180), (Vector3fc)axis.m_253071_());
            currentDir.rotate((Quaternionfc)q);
            Vec3 newDir = new Vec3(currentDir);
            tile.setRestrainedYaw((float)MthUtils.getYaw((Vec3)newDir));
            tile.setRestrainedPitch((float)MthUtils.getPitch((Vec3)newDir));
            tile.m_6596_();
            tile.m_58904_().m_7260_(pos, oldState, newState, 3);
        }
    }
}

