/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.harvester;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.compat.harvest.HarvestCompat;
import net.permutated.pylons.compat.harvest.Harvestable;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.machines.harvester.HarvesterPylonBlock;

public class HarvesterPylonTile
extends AbstractPylonTile {
    Status workStatus = Status.NONE;

    public HarvesterPylonTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.HARVESTER_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected byte[] getRange() {
        return new byte[]{3, 5, 7, 9};
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.m_41720_() instanceof HoeItem;
    }

    @Override
    protected boolean canAccessInventory() {
        return (Boolean)ConfigManager.SERVER.harvesterCanBeAutomated.get();
    }

    private boolean requiresTool() {
        return Boolean.TRUE.equals(ConfigManager.SERVER.harvesterRequiresTool.get());
    }

    private int getWorkDelay() {
        return (Integer)ConfigManager.SERVER.harvesterWorkDelay.get();
    }

    @Override
    public void updateContainer(FriendlyByteBuf packetBuffer) {
        super.updateContainer(packetBuffer);
        packetBuffer.m_130068_((Enum)this.workStatus);
    }

    @Override
    public void tick() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(this.getWorkDelay())) {
                boolean waterlogged;
                BlockPos above = this.m_58899_().m_7494_();
                BlockEntity target = this.f_58857_.m_7702_(above);
                if (target == null) {
                    this.workStatus = Status.MISSING_INVENTORY;
                    return;
                }
                IItemHandler itemHandler = target.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).resolve().orElse(null);
                if (itemHandler == null) {
                    this.workStatus = Status.MISSING_INVENTORY;
                    return;
                }
                int hoeSlot = -1;
                if (this.requiresTool()) {
                    for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                        if (!this.isItemValid(this.itemStackHandler.getStackInSlot(i))) continue;
                        hoeSlot = i;
                        break;
                    }
                    if (hoeSlot == -1) {
                        this.workStatus = Status.MISSING_TOOL;
                        return;
                    }
                }
                int workY = (waterlogged = ((Boolean)this.m_58900_().m_61143_((Property)HarvesterPylonBlock.WATERLOGGED)).booleanValue()) ? above.m_123342_() : this.m_58899_().m_123342_();
                int radius = (this.range.get() - 1) / 2;
                int minX = above.m_123341_() - radius;
                int minZ = above.m_123343_() - radius;
                int maxX = above.m_123341_() + radius;
                int maxZ = above.m_123343_() + radius;
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        boolean result;
                        ItemStack stack;
                        Harvestable harvestable;
                        BlockPos workPos = new BlockPos(x, workY, z);
                        if (!this.f_58857_.m_46749_(workPos)) continue;
                        BlockState blockState = this.f_58857_.m_8055_(workPos);
                        Block block = blockState.m_60734_();
                        if (block instanceof CropBlock) {
                            CropBlock crop = (CropBlock)block;
                            int currentAge = crop.m_52305_(blockState);
                            int maxAge = crop.m_7419_();
                            if (0 == maxAge || currentAge < maxAge) continue;
                            if (this.requiresTool()) {
                                if (hoeSlot == -1) {
                                    this.workStatus = Status.MISSING_TOOL;
                                    return;
                                }
                                ItemStack replace = this.itemStackHandler.getStackInSlot(hoeSlot).m_41777_();
                                if (replace.m_220157_(1, this.f_58857_.m_213780_(), null)) {
                                    replace.m_41774_(1);
                                }
                                this.itemStackHandler.setStackInSlot(hoeSlot, replace);
                            }
                            ItemStack seedStack = crop.m_7397_((BlockGetter)this.f_58857_, workPos, blockState);
                            List drops = Block.m_49869_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)workPos, null);
                            BlockState modified = crop.m_52289_(0);
                            boolean updated = this.f_58857_.m_46597_(workPos, modified);
                            if (!updated) {
                                this.workStatus = Status.UPDATE_ERROR;
                                Pylons.LOGGER.error("Failed to reset crop age for position: {}", (Object)workPos);
                                return;
                            }
                            for (ItemStack drop : drops) {
                                boolean result2;
                                if (!seedStack.m_41619_() && drop.m_41720_() == seedStack.m_41720_()) {
                                    drop.m_41774_(1);
                                }
                                if (drop.m_41619_() || (result2 = this.insertItemOrDiscard(itemHandler, drop))) continue;
                                this.workStatus = Status.INVENTORY_FULL;
                                return;
                            }
                            continue;
                        }
                        if (!HarvestCompat.hasCompat(blockState.m_60734_()) || !(harvestable = HarvestCompat.getCompat(blockState.m_60734_())).isHarvestable(blockState)) continue;
                        if (this.requiresTool()) {
                            if (hoeSlot == -1) {
                                this.workStatus = Status.MISSING_TOOL;
                                return;
                            }
                            ItemStack replace = this.itemStackHandler.getStackInSlot(hoeSlot).m_41777_();
                            if (replace.m_220157_(1, this.f_58857_.m_213780_(), null)) {
                                replace.m_41774_(1);
                            }
                            this.itemStackHandler.setStackInSlot(hoeSlot, replace);
                        }
                        if ((stack = harvestable.harvest(this.f_58857_, workPos, blockState)).m_41619_() || (result = this.insertItemOrDiscard(itemHandler, stack))) continue;
                        this.workStatus = Status.INVENTORY_FULL;
                        return;
                    }
                }
                this.workStatus = Status.WORKING;
            }
        }
    }

    private boolean insertItemOrDiscard(IItemHandler itemHandler, ItemStack itemStack) {
        ItemStack progress = itemStack;
        for (int slot = 0; slot < itemHandler.getSlots() && !(progress = itemHandler.insertItem(slot, progress, false)).m_41619_(); ++slot) {
        }
        return progress.m_41619_();
    }

    public static enum Status {
        NONE,
        WORKING,
        MISSING_TOOL,
        MISSING_INVENTORY,
        INVENTORY_FULL,
        UPDATE_ERROR;

    }
}

