/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementResourceStorage;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;

public class ElementFluidStorage
extends ElementResourceStorage {
    protected FluidStorageCoFH tank;
    protected TextureAtlasSprite fluidTexture;

    public ElementFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage) {
        super(gui, posX, posY, storage);
        this.tank = storage;
    }

    public ElementFluidStorage setFluidTexture(TextureAtlasSprite fluidTexture) {
        this.fluidTexture = fluidTexture;
        return this;
    }

    @Override
    protected void drawResource(PoseStack poseStack) {
        boolean invert;
        int resourceHeight = this.height - 2;
        int resourceWidth = this.width - 2;
        int amount = this.getScaled(resourceHeight);
        boolean bl = invert = FluidHelper.density(this.tank.getFluidStack()) < 0;
        if (this.fluidTexture != null) {
            RenderHelper.setBlockTextureSheet();
            RenderHelper.drawTiledTexture(this.guiLeft() + this.posX() + 1, this.guiTop() + this.posY() + 1 + (invert ? 0 : resourceHeight - amount), this.fluidTexture, resourceWidth, amount);
        } else {
            RenderHelper.drawFluid(this.guiLeft() + this.posX() + 1, this.guiTop() + this.posY() + 1 + (invert ? 0 : resourceHeight - amount), this.tank.getFluidStack(), resourceWidth, amount);
        }
    }

    @Override
    protected void drawOverlayTexture(PoseStack poseStack) {
        if (!((Boolean)this.drawOverlay.get()).booleanValue()) {
            return;
        }
        if (this.storage.isCreative() && this.creativeTexture != null) {
            RenderHelper.setShaderTexture0(this.creativeTexture);
            this.drawTexturedModalRect(poseStack, this.posX(), this.posY(), 0, 0, this.width, this.height);
        } else {
            super.drawOverlayTexture(poseStack);
        }
    }

    @Override
    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        if (this.storage.getStored() > 0) {
            tooltipList.add((Component)StringHelper.getFluidName(this.tank.getFluidStack()));
            if (FluidHelper.hasPotionTag(this.tank.getFluidStack())) {
                FluidHelper.addPotionTooltip(this.tank.getFluidStack(), tooltipList);
            }
        }
        super.addTooltip(tooltipList, mouseX, mouseY);
    }
}

