/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourceLocation;
import stepsword.mahoutsukai.render.GifInfo;
import stepsword.mahoutsukai.render.ImageFrame;
import stepsword.mahoutsukai.util.ClientImageDownloadUtil;
import stepsword.mahoutsukai.util.Utils;

public class GifLoader {
    public static boolean isGIF(byte[] bytes) {
        try {
            boolean gif = Byte.compare(bytes[0], (byte)71) == 0 && Byte.compare(bytes[1], (byte)73) == 0 && Byte.compare(bytes[2], (byte)70) == 0 && Byte.compare(bytes[3], (byte)56) == 0 && Byte.compare(bytes[4], (byte)57) == 0 && Byte.compare(bytes[5], (byte)97) == 0;
            return gif;
        }
        catch (Exception e) {
            Utils.err(e.toString());
            return false;
        }
    }

    public static NativeImage loadGif(InputStream input, ResourceLocation loc) {
        NativeImage ret = null;
        try {
            try {
                ImageFrame[] frames = ImageFrame.readGif(input);
                int count = frames.length;
                int height = 0;
                int width = 0;
                for (int f = 0; f < frames.length; ++f) {
                    if (frames[f].getWidth() > width) {
                        width = frames[f].getWidth();
                    }
                    if (frames[f].getHeight() <= height) continue;
                    height = frames[f].getHeight();
                }
                if (width > height) {
                    height = width;
                }
                int images_per_side = (int)Math.ceil(Math.sqrt(count));
                int side = images_per_side * height;
                BufferedImage sheet = new BufferedImage(side, side, 2);
                int q = 0;
                int m = 0;
                for (int index = 0; index < count; ++index) {
                    BufferedImage frame = frames[index].getImage();
                    GifLoader.joinBufferedImage(sheet, frame, q * width, m * height);
                    if (++q != images_per_side) continue;
                    q = 0;
                    ++m;
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)sheet, "png", os);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                ret = NativeImage.m_85058_((InputStream)is);
                ClientImageDownloadUtil.gifmap.put(loc, new GifInfo(width, height, count));
            }
            catch (Exception e) {
                Utils.err(e.toString());
            }
        }
        catch (Exception ex) {
            Utils.err(ex.toString());
        }
        return ret;
    }

    public static void joinBufferedImage(BufferedImage sheet, BufferedImage img, int startw, int starth) {
        Graphics2D g2 = sheet.createGraphics();
        Color oldColor = g2.getColor();
        g2.setColor(oldColor);
        g2.drawImage(img, null, starth, startw);
        g2.dispose();
    }

    public static float[] getUVFromGIF(long frame, GifInfo gif) {
        float[] ret = new float[4];
        int images_per_side = (int)Math.ceil(Math.sqrt(gif.framecount));
        float unit = 1.0f / (float)images_per_side;
        float u1 = (float)((frame %= (long)gif.framecount) / (long)images_per_side) * unit;
        float u2 = Math.min(1.0f, u1 + unit);
        float v1 = (float)((int)(frame % (long)images_per_side)) * unit;
        float v2 = Math.min(1.0f, v1 + unit);
        ret[0] = u1;
        ret[1] = u2;
        ret[2] = v1;
        ret[3] = v2;
        return ret;
    }
}

