/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.VanillaGameEvent;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.RipperInvisiblePacket;
import stepsword.mahoutsukai.potion.CooldownPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RipperInvisCooldownPotion;
import stepsword.mahoutsukai.util.EffectUtil;

public class RipperInvisPotion
extends CooldownPotion {
    protected RipperInvisPotion() {
    }

    public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMapIn, int amplifier) {
        RipperInvisPotion.notifyNotInvisible(livingEntity);
        EffectUtil.debuff(livingEntity, MobEffects.f_19609_);
    }

    public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMapIn, int amplifier) {
        RipperInvisPotion.notifyIfInvisible(livingEntity);
        EffectUtil.buff(livingEntity, MobEffects.f_19609_, false, 2000000000, false);
    }

    public static void notifyIfInvisible(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (EffectUtil.hasBuff(e, ModEffects.RIPPER_INVISIBILITY)) {
            RipperInvisPotion.notifyTracking(lst, true, e.m_9236_());
        }
    }

    public static void notifyNotInvisible(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        RipperInvisPotion.notifyTracking(lst, false, e.m_9236_());
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, Level world) {
        if (world instanceof ServerLevel) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new RipperInvisiblePacket(e.m_19879_(), r));
            }
        }
    }

    public static void presenceConcealmentLivingTick(LivingEntity e) {
        if (EffectUtil.hasBuff(e, ModEffects.RIPPER_INVISIBILITY)) {
            RipperInvisCooldownPotion.nudge(e);
        }
    }

    public static boolean presenceConcealmentNoSound(VanillaGameEvent event) {
        Entity e = event.getCause();
        Entity src = event.getContext().f_223711_();
        boolean w = e instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)e, ModEffects.RIPPER_INVISIBILITY);
        boolean q = src instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)src, ModEffects.RIPPER_INVISIBILITY);
        return w || q;
    }
}

