/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class AuthorityStickPacket {
    boolean stick;

    public AuthorityStickPacket() {
    }

    public AuthorityStickPacket(boolean stick) {
        this.stick = stick;
    }

    public void fromBytes(ByteBuf buf) {
        this.stick = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.stick);
    }

    public static void encode(AuthorityStickPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static AuthorityStickPacket decode(FriendlyByteBuf buf) {
        AuthorityStickPacket msg = new AuthorityStickPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final AuthorityStickPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                AuthorityStickPacket.authorityStick(message, ((NetworkEvent.Context)context.get()).getSender());
            }
        });
    }

    public static void authorityStick(AuthorityStickPacket message, ServerPlayer player) {
        if (player != null && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BORROWED_AUTHORITY)) {
            if (message.stick) {
                EffectUtil.buff((LivingEntity)player, ModEffects.WALL_STICK, false, 2000);
            } else {
                EffectUtil.debuff((LivingEntity)player, ModEffects.WALL_STICK);
            }
        }
    }
}

