/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.worldsave;

import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import stepsword.mahoutsukai.capability.worldsave.IWorldMahou;

public class WorldMahouStorage {
    public static final String realityMarblePlayers = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_LIST";
    public static final String marblePlayerID = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_ID";
    public static final String marblePlayerSpawnX = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_SPAWN_X";
    public static final String marblePlayerSpawnY = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_SPAWN_Y";
    public static final String marblePlayerSpawnZ = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_SPAWN_Z";
    public static final String contractPlayers = "MAHOUTSUKAI_CONTRACT_PLAYER_LIST";
    public static final String contractPlayerIDA = "MAHOUTSUKAI_CONTRACT_PLAYER_A";
    public static final String contractPlayerIDB = "MAHOUTSUKAI_CONTRACT_PLAYER_B";

    public static Tag writeNBT(IWorldMahou instance) {
        CompoundTag compound = new CompoundTag();
        CompoundTag reality = new CompoundTag();
        int z = 0;
        for (UUID tmp : instance.getRealityMarbleSpawns().keySet()) {
            BlockPos pos = instance.getRealityMarbleSpawns().get(tmp);
            if (pos == null) continue;
            CompoundTag nbttmp = new CompoundTag();
            nbttmp.m_128362_(marblePlayerID, tmp);
            nbttmp.m_128405_(marblePlayerSpawnX, pos.m_123341_());
            nbttmp.m_128405_(marblePlayerSpawnY, pos.m_123342_());
            nbttmp.m_128405_(marblePlayerSpawnZ, pos.m_123343_());
            reality.m_128365_("MAHOUTSUKAI_PLAYER_ID_" + z, (Tag)nbttmp);
            ++z;
        }
        compound.m_128365_(realityMarblePlayers, (Tag)reality);
        CompoundTag contracts = new CompoundTag();
        CompoundTag nbtcctmp = null;
        int c = 0;
        for (UUID tmp : instance.getContracts().keySet()) {
            Collection coll = instance.getContracts().get((Object)tmp);
            for (UUID tmp2 : coll) {
                nbtcctmp = new CompoundTag();
                nbtcctmp.m_128362_(contractPlayerIDA, tmp);
                nbtcctmp.m_128362_(contractPlayerIDB, tmp2);
                contracts.m_128365_("MAHOUTSUKAI_CONTRACT_ID_" + c, (Tag)nbtcctmp);
                ++c;
            }
        }
        compound.m_128365_(contractPlayers, (Tag)contracts);
        return compound;
    }

    public static void readNBT(IWorldMahou instance, Tag nbtb) {
        CompoundTag nbt = (CompoundTag)nbtb;
        if (nbt.m_128441_(realityMarblePlayers)) {
            for (String tmp : ((CompoundTag)nbt.m_128423_(realityMarblePlayers)).m_128431_()) {
                CompoundTag nbttmp = (CompoundTag)((CompoundTag)nbt.m_128423_(realityMarblePlayers)).m_128423_(tmp);
                if (nbttmp == null || !nbttmp.m_128403_(marblePlayerID)) continue;
                UUID uuid = nbttmp.m_128342_(marblePlayerID);
                BlockPos pos = new BlockPos(nbttmp.m_128451_(marblePlayerSpawnX), nbttmp.m_128451_(marblePlayerSpawnY), nbttmp.m_128451_(marblePlayerSpawnZ));
                instance.getRealityMarbleSpawns().put(uuid, pos);
            }
        }
        if (nbt.m_128441_(contractPlayers)) {
            for (String tmp : ((CompoundTag)nbt.m_128423_(contractPlayers)).m_128431_()) {
                CompoundTag nbtc = (CompoundTag)((CompoundTag)nbt.m_128423_(contractPlayers)).m_128423_(tmp);
                if (!nbtc.m_128403_(contractPlayerIDA) || !nbtc.m_128403_(contractPlayerIDB)) continue;
                instance.getContracts().put((Object)nbtc.m_128342_(contractPlayerIDA), (Object)nbtc.m_128342_(contractPlayerIDB));
                instance.getContracts().put((Object)nbtc.m_128342_(contractPlayerIDB), (Object)nbtc.m_128342_(contractPlayerIDA));
            }
        }
    }
}

