/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.xmod.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.recipes.IngredientStack;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import net.pedroksl.advanced_ae.xmod.emi.recipes.EMIReactionChamberRecipe;

@EmiEntrypoint
public class EMIPlugin
implements EmiPlugin {
    public static final ResourceLocation TEXTURE = AdvancedAE.makeId("textures/guis/emi.png");

    public void register(EmiRegistry registry) {
        registry.addCategory(EMIReactionChamberRecipe.CATEGORY);
        registry.addWorkstation(EMIReactionChamberRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemStack)AAEBlocks.REACTION_CHAMBER.stack()));
        EMIPlugin.adaptRecipeType(registry, ReactionChamberRecipe.TYPE, EMIReactionChamberRecipe::new);
        EMIPlugin.addInfo(registry, AAEBlocks.ADV_PATTERN_PROVIDER, new Component[]{AAEText.AdvPatternProviderEmiDesc.text()});
    }

    private static <C extends Container, T extends Recipe<C>> void adaptRecipeType(EmiRegistry registry, RecipeType<T> recipeType, Function<T, ? extends EmiRecipe> adapter) {
        registry.getRecipeManager().m_44013_(recipeType).stream().map(adapter).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private static void addInfo(EmiRegistry registry, ItemLike item, Component ... desc) {
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)item)), Arrays.stream(desc).toList(), null));
    }

    public static EmiIngredient stackOf(IngredientStack.Item stack) {
        return !stack.isEmpty() ? EmiIngredient.of((Ingredient)((Ingredient)stack.getIngredient()), (long)stack.getAmount()) : EmiStack.EMPTY;
    }

    public static EmiIngredient stackOf(IngredientStack.Fluid stack) {
        return !stack.isEmpty() ? EmiStack.of((Fluid)stack.getStack().getFluid(), (long)stack.getAmount()) : EmiStack.EMPTY;
    }
}

