/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.ISubMenuHost;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.networking.WirelessAccessPointBlockEntity;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.items.armors.IGridLinkedItem;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import org.jetbrains.annotations.Nullable;

public class PickCraftMenuHost<T extends QuantumArmorBase>
extends ItemMenuHost
implements ISubMenuHost,
IActionHost {
    @Nullable
    private IWirelessAccessPoint currentAccessPoint;
    protected double currentDistanceFromGrid = Double.MAX_VALUE;
    protected double currentRemainingRange = Double.MIN_VALUE;

    public PickCraftMenuHost(Player player, int inventorySlot, ItemStack stack) {
        super(player, Integer.valueOf(inventorySlot), stack);
        this.updateConnectedAccessPoint();
    }

    private IGrid getLinkedGrid(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IGridLinkedItem) {
            IGridLinkedItem item2 = (IGridLinkedItem)item;
            return item2.getLinkedGrid(stack, this.getPlayer().m_9236_());
        }
        return null;
    }

    public void tick() {
        this.updateConnectedAccessPoint();
        this.drainPower();
    }

    protected void updateConnectedAccessPoint() {
        this.currentAccessPoint = null;
        this.currentDistanceFromGrid = Double.MAX_VALUE;
        this.currentRemainingRange = Double.MIN_VALUE;
        IGrid targetGrid = this.getLinkedGrid(this.getItemStack());
        if (targetGrid != null) {
            @Nullable WirelessAccessPointBlockEntity bestWap = null;
            double bestSqDistance = Double.MAX_VALUE;
            double bestSqRemainingRange = Double.MIN_VALUE;
            for (WirelessAccessPointBlockEntity wap : targetGrid.getMachines(WirelessAccessPointBlockEntity.class)) {
                AccessPointSignal signal = this.getAccessPointSignal((IWirelessAccessPoint)wap);
                if (signal.distanceSquared < bestSqDistance) {
                    bestSqDistance = signal.distanceSquared;
                    bestWap = wap;
                }
                if (!(signal.remainingRangeSquared > bestSqRemainingRange)) continue;
                bestSqRemainingRange = signal.remainingRangeSquared;
            }
            this.currentAccessPoint = bestWap;
            this.currentDistanceFromGrid = Math.sqrt(bestSqDistance);
            this.currentRemainingRange = Math.sqrt(bestSqRemainingRange);
        }
    }

    protected AccessPointSignal getAccessPointSignal(IWirelessAccessPoint wap) {
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalBlockPos dc = wap.getLocation();
        if (dc.getLevel() == this.getPlayer().m_9236_()) {
            double offX = (double)dc.getPos().m_123341_() - this.getPlayer().m_20185_();
            double offY = (double)dc.getPos().m_123342_() - this.getPlayer().m_20186_();
            double offZ = (double)dc.getPos().m_123343_() - this.getPlayer().m_20189_();
            double r = offX * offX + offY * offY + offZ * offZ;
            if (wap.isActive()) {
                return new AccessPointSignal(r, rangeLimit - r);
            }
        }
        return new AccessPointSignal(Double.MAX_VALUE, Double.MIN_VALUE);
    }

    @Nullable
    public IGridNode getActionableNode() {
        if (this.currentAccessPoint != null) {
            return this.currentAccessPoint.getActionableNode();
        }
        return null;
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        ((AEBaseMenu)this.getPlayer().f_36096_).setValidMenu(false);
    }

    public ItemStack getMainMenuIcon() {
        return this.getItemStack();
    }

    public record AccessPointSignal(double distanceSquared, double remainingRangeSquared) {
    }
}

