/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AECheckbox;
import appeng.client.gui.widgets.IconButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.definitions.AEItems;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.UpgradeableMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEActionItems;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEServerSettingToggleButton;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEToolbarActionButton;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.gui.QuantumCrafterMenu;

public class QuantumCrafterScreen
extends UpgradeableScreen<QuantumCrafterMenu> {
    private final SettingToggleButton<RedstoneMode> redstoneMode;
    private final AAEServerSettingToggleButton<YesNo> meExportBtn;
    private final AAEToolbarActionButton outputConfigure;
    private final List<Button> configButtons = new ArrayList<Button>();
    private final List<AECheckbox> enableButtons = new ArrayList<AECheckbox>();

    public QuantumCrafterScreen(QuantumCrafterMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.redstoneMode = new ServerSettingToggleButton(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.addToLeftToolbar((Button)this.redstoneMode);
        this.meExportBtn = new AAEServerSettingToggleButton<YesNo>(AAESettings.ME_EXPORT, YesNo.NO);
        this.addToLeftToolbar(this.meExportBtn);
        this.outputConfigure = new AAEToolbarActionButton(AAEActionItems.DIRECTIONAL_OUTPUT, btn -> menu.configureOutput());
        this.outputConfigure.setVisibility(((QuantumCrafterMenu)this.m_6262_()).getMeExport() == YesNo.NO);
        this.addToLeftToolbar(this.outputConfigure);
        List patternSlots = menu.getSlots(SlotSemantics.MACHINE_INPUT);
        for (int i = 0; i < patternSlots.size(); ++i) {
            ConfigButton cfgButton = new ConfigButton(btn -> {
                int idx = this.configButtons.indexOf(btn);
                menu.configPattern(idx);
            });
            cfgButton.setDisableBackground(true);
            cfgButton.m_93666_((Component)AAEText.ConfigurePatternButton.text());
            this.widgets.add("cfgButton" + (1 + i), (AbstractWidget)cfgButton);
            this.configButtons.add((Button)cfgButton);
            AECheckbox enableButton = this.widgets.addCheckbox("enableButton" + (1 + i), (Component)Component.m_237119_(), (Runnable)new onEnableToggle(i));
            enableButton.m_257544_(Tooltip.m_257550_((Component)AAEText.EnablePatternButton.text()));
            this.enableButtons.add(enableButton);
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.redstoneMode.set((Enum)((QuantumCrafterMenu)this.f_97732_).getRedStoneMode());
        this.redstoneMode.setVisibility(((QuantumCrafterMenu)this.f_97732_).hasUpgrade((ItemLike)AEItems.REDSTONE_CARD));
        this.meExportBtn.set(((QuantumCrafterMenu)this.m_6262_()).getMeExport());
        this.outputConfigure.setVisibility(((QuantumCrafterMenu)this.m_6262_()).getMeExport() == YesNo.NO);
    }

    public void updateEnabledButtons(List<Boolean> enabledButtons) {
        for (int x = 0; x < this.enableButtons.size(); ++x) {
            if (enabledButtons.size() <= x) continue;
            this.enableButtons.get(x).setSelected(enabledButtons.get(x).booleanValue());
        }
    }

    static class ConfigButton
    extends IconButton {
        public ConfigButton(Button.OnPress onPress) {
            super(onPress);
        }

        protected Icon getIcon() {
            return this.m_198029_() ? Icon.WRENCH : Icon.WRENCH_DISABLED;
        }
    }

    private class onEnableToggle
    implements Runnable {
        private final int index;

        onEnableToggle(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            ((QuantumCrafterMenu)QuantumCrafterScreen.this.f_97732_).toggleEnablePattern(this.index);
        }
    }
}

