/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.api;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.externalstorage.GenericStackInv;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.pedroksl.advanced_ae.network.packet.FluidTankClientAudioPacket;

public interface IFluidTankHandler {
    public ItemStack getCarriedItem();

    public void setCarriedItem(ItemStack var1);

    public GenericStackInv getTank();

    public boolean canExtractFromTank(int var1);

    public boolean canInsertInto(int var1);

    public void playAudioCues(FluidTankClientAudioPacket var1);

    default public void onItemUse(int index, int button) {
        ItemStack stack = this.getCarriedItem();
        if (!stack.m_41619_()) {
            LazyOptional forgeCap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            forgeCap.ifPresent(cap -> {
                GenericStackInv tank = this.getTank();
                if (tank == null) {
                    return;
                }
                if (button == 0) {
                    if (!this.canExtractFromTank(index)) {
                        return;
                    }
                    GenericStack genStack = tank.getStack(index);
                    if (genStack != null && genStack.what() != null) {
                        FluidStack fluid = ((AEFluidKey)genStack.what()).toStack((int)genStack.amount());
                        long extracted = Math.min(genStack.amount(), 1000L);
                        int inserted = cap.fill(new FluidStack(fluid.getFluid(), (int)extracted), IFluidHandler.FluidAction.EXECUTE);
                        long endAmount = genStack.amount() - (long)inserted;
                        if (endAmount > 0L) {
                            tank.setStack(index, new GenericStack(genStack.what(), genStack.amount() - (long)inserted));
                        } else {
                            tank.setStack(index, null);
                        }
                        this.setCarriedItem(cap.getContainer());
                        if (inserted > 0) {
                            this.playAudioCues(new FluidTankClientAudioPacket(false));
                        }
                    }
                } else {
                    if (!this.canInsertInto(index) || cap.getFluidInTank(0).isEmpty()) {
                        return;
                    }
                    FluidStack fluid = cap.getFluidInTank(0);
                    GenericStack genStack = GenericStack.fromFluidStack((FluidStack)fluid);
                    if (genStack != null && genStack.what() != null && !cap.drain((int)tank.insert(index, genStack.what(), 1000L, Actionable.SIMULATE), IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                        long inserted;
                        int extracted = cap.drain(1000, IFluidHandler.FluidAction.EXECUTE).getAmount();
                        if ((long)extracted - (inserted = tank.insert(index, genStack.what(), (long)extracted, Actionable.MODULATE)) > 0L) {
                            cap.fill(new FluidStack(fluid.getFluid(), (int)((long)extracted - inserted)), IFluidHandler.FluidAction.EXECUTE);
                        }
                        this.setCarriedItem(cap.getContainer());
                        this.playAudioCues(new FluidTankClientAudioPacket(true));
                    }
                }
            });
        }
    }
}

