/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class SingleConditionalRecipe {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private FinishedRecipe recipe = null;
        private ResourceLocation advId;
        private ConditionalAdvancement.Builder adv;

        public Builder addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder setRecipe(Consumer<Consumer<FinishedRecipe>> callable) {
            callable.accept(this::setRecipe);
            return this;
        }

        public Builder setRecipe(BiConsumer<Consumer<FinishedRecipe>, ResourceLocation> callable, ResourceLocation recipeId) {
            callable.accept(this::setRecipe, recipeId);
            return this;
        }

        public Builder setRecipe(FinishedRecipe recipe) {
            if (this.conditions.isEmpty()) {
                throw new IllegalStateException("Cannot add a recipe with no conditions.");
            }
            this.recipe = recipe;
            return this;
        }

        public Builder generateAdvancement(@Nullable ResourceLocation id) {
            ConditionalAdvancement.Builder builder = ConditionalAdvancement.builder();
            for (ICondition cond : this.conditions) {
                builder = builder.addCondition(cond);
            }
            builder = builder.addAdvancement(this.recipe);
            return this.setAdvancement(id, builder);
        }

        public Builder setAdvancement(ConditionalAdvancement.Builder advancement) {
            return this.setAdvancement(null, advancement);
        }

        public Builder setAdvancement(@Nullable ResourceLocation id, ConditionalAdvancement.Builder advancement) {
            if (this.adv != null) {
                throw new IllegalStateException("Invalid SingleConditionalRecipeBuilder, Advancement already set");
            }
            this.advId = id;
            this.adv = advancement;
            return this;
        }

        public void build(Consumer<FinishedRecipe> consumer, String namespace, String path) {
            this.build(consumer, new ResourceLocation(namespace, path));
        }

        public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            if (this.recipe == null) {
                throw new IllegalStateException("Invalid SingleConditionalRecipe builder, No recipe");
            }
            if (this.advId == null && this.adv != null) {
                this.advId = new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_());
            }
            consumer.accept(new Finished(id, this.conditions, this.recipe, this.advId, this.adv));
        }
    }

    private record Finished(ResourceLocation id, List<ICondition> conditions, FinishedRecipe recipe, ResourceLocation advId, ConditionalAdvancement.Builder adv) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
        }

        public JsonObject m_125966_() {
            JsonObject json = this.recipe.m_125966_();
            JsonArray jsonConditions = new JsonArray();
            for (ICondition condition : this.conditions) {
                jsonConditions.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)jsonConditions);
            return json;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.recipe.m_6637_();
        }

        public JsonObject m_5860_() {
            return this.adv == null ? null : this.adv.write();
        }

        public ResourceLocation m_6448_() {
            return this.advId;
        }
    }
}

