/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.mixins.impl;

import me.srrapero720.chloride.ChlorideConfig;
import me.srrapero720.chloride.features.FastBlocksFeature;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class FastBlocksMixins {

    @Mixin(value={BlockEntityRenderDispatcher.class})
    public static class TileRenderMixin {
        @Inject(method={"getRenderer"}, at={@At(value="HEAD")}, cancellable=true)
        private <E extends BlockEntity> void inject$disableRenderer(E blockEntity, CallbackInfoReturnable<BlockEntityRenderer<E>> cir) {
            Class<?> beClass = blockEntity.getClass();
            if (ChlorideConfig.fastChests && FastBlocksFeature.canUseOnChests() && (beClass == ChestBlockEntity.class || beClass == EnderChestBlockEntity.class)) {
                cir.setReturnValue(null);
            }
            if (ChlorideConfig.fastBeds && beClass == BedBlockEntity.class) {
                cir.setReturnValue(null);
            }
        }
    }

    @Mixin(value={ChestBlock.class, EnderChestBlock.class})
    public static class ChestsMixin {
        @Inject(method={"getTicker"}, at={@At(value="HEAD")}, cancellable=true)
        private <T extends BlockEntity> void inject$removeTicker(Level level, BlockState state, BlockEntityType<T> type, CallbackInfoReturnable<BlockEntityTicker<T>> cir) {
            if (FastBlocksFeature.canUseOnChests() && ChlorideConfig.fastChests) {
                cir.setReturnValue(null);
            }
        }

        @Inject(method={"getRenderShape"}, at={@At(value="HEAD")}, cancellable=true)
        private void inject$replaceRenderShape(BlockState state, CallbackInfoReturnable<RenderShape> cir) {
            if (FastBlocksFeature.canUseOnChests() && ChlorideConfig.fastChests) {
                cir.setReturnValue((Object)RenderShape.MODEL);
            }
        }
    }

    @Mixin(value={BedBlock.class})
    public static abstract class BedMixin
    extends BlockBehaviour {
        public BedMixin(BlockBehaviour.Properties pProperties) {
            super(pProperties);
        }

        @Inject(method={"getRenderShape"}, at={@At(value="RETURN")}, cancellable=true)
        private void inject$replaceRenderShape(BlockState state, CallbackInfoReturnable<RenderShape> cir) {
            if (ChlorideConfig.fastBeds) {
                cir.setReturnValue((Object)RenderShape.MODEL);
            }
        }

        public boolean m_6104_(BlockState state, BlockState neighborState, Direction direction) {
            return neighborState.m_60734_() instanceof BedBlock;
        }
    }
}

