/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class Tools {
    private static final Marker IT = MarkerManager.getMarker((String)"Tools");

    public static List<ResourceLocation> toId(String ... ids) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (String id : ids) {
            if (id.endsWith(":*")) {
                id = id.replace(":*", ":all");
            }
            result.add(ResourceLocation.m_135820_((String)id));
        }
        return result;
    }

    public static Pair<String, String> resourceLocationPair(String res) {
        String[] r = res.split(":");
        try {
            Pair pair = Pair.of((Object)r[0], (Object)r[1]);
            return pair;
        }
        finally {
            r[0] = null;
            r[1] = null;
            r = null;
        }
    }

    public static ChatFormatting colorByLow(int usage) {
        return usage < 9 ? ChatFormatting.DARK_RED : (usage < 16 ? ChatFormatting.RED : (usage < 30 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static ChatFormatting colorByPercent(int usage) {
        return usage >= 100 ? ChatFormatting.DARK_RED : (usage >= 90 ? ChatFormatting.RED : (usage >= 75 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static String tintByLower(int usage) {
        return (usage < 9 ? ChatFormatting.DARK_RED : (usage < 16 ? ChatFormatting.RED : (usage < 30 ? ChatFormatting.GOLD : ChatFormatting.RESET))).toString() + usage;
    }

    public static String tintByPercent(long usage) {
        return (usage >= 100L ? ChatFormatting.DARK_RED : (usage >= 90L ? ChatFormatting.RED : (usage >= 75L ? ChatFormatting.GOLD : ChatFormatting.RESET))).toString() + usage;
    }

    public static boolean isWhitelisted(ResourceLocation entityOrTile, List<ResourceLocation> configValue) {
        for (ResourceLocation item : configValue) {
            if (entityOrTile.equals((Object)item)) {
                return true;
            }
            if (!entityOrTile.m_135827_().equals(item.m_135827_()) || !entityOrTile.m_135815_().equals("all")) continue;
            return true;
        }
        return false;
    }

    public static int getColorARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static long ramUsed() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long bytesToMB(long input) {
        return input / 1024L / 1024L;
    }

    public static boolean isModInstalled(String modid) {
        return FMLLoader.getLoadingModList().getModFileById(modid) != null;
    }

    public static boolean isEntityInRange(BlockPos pos, Vec3 cam, int maxHeight, int maxDistanceSqr) {
        return Tools.isEntityInRange(pos.m_252807_(), cam, maxHeight, maxDistanceSqr);
    }

    public static boolean isEntityInRange(Entity entity, double camX, double camY, double camZ, int maxHeight, int maxDistanceSqr) {
        return Tools.isEntityInRange(entity.m_20182_(), new Vec3(camX, camY, camZ), maxHeight, maxDistanceSqr);
    }

    public static boolean isEntityInRange(Vec3 position, Vec3 camera, int maxHeight, int maxDistanceSqr) {
        if (Math.abs(position.f_82480_ - camera.f_82480_ - 4.0) < (double)maxHeight) {
            double x = position.f_82479_ - camera.f_82479_;
            double z = position.f_82481_ - camera.f_82481_;
            return x * x + z * z < (double)maxDistanceSqr;
        }
        return false;
    }
}

