/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import java.util.Collections;
import java.util.List;
import me.srrapero720.chloride.Chloride;
import me.srrapero720.chloride.ChlorideConfig;
import me.srrapero720.chloride.Tools;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ChlorideConfig_Old {
    public static final Marker IT = MarkerManager.getMarker((String)"Config");
    public static ForgeConfigSpec SPECS;

    public static void tryRestore() {
        block4: {
            File path = FMLPaths.CONFIGDIR.get().resolve("embeddium++.toml").toFile();
            if (!path.exists()) {
                return;
            }
            Chloride.LOGGER.warn(IT, "Restoring config from old Embeddium++Config");
            try {
                CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((File)path).sync().writingMode(WritingMode.REPLACE).build();
                configData.load();
                ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
                BUILDER.push("embeddiumplus");
                BUILDER.push("general");
                ForgeConfigSpec.EnumValue fullScreen = BUILDER.comment(new String[]{"Set Fullscreen mode", "Borderless let you change between screens more faster and move your mouse across monitors"}).defineEnum("fullscreen", (Enum)ChlorideConfig.FullScreenMode.WINDOWED);
                ForgeConfigSpec.EnumValue fpsDisplayMode = BUILDER.comment(new String[]{"Configure FPS Display mode", "Complete mode gives you min FPS count and average count"}).defineEnum("fpsDisplay", (Enum)ChlorideConfig.FPSDisplayMode.ADVANCED);
                ForgeConfigSpec.EnumValue fpsDisplayGravity = BUILDER.comment(new String[]{"Configure FPS Display gravity", "Places counter on specified corner of your screen"}).defineEnum("fpsDisplayGravity", (Enum)ChlorideConfig.FPSDisplayAlign.LEFT);
                ForgeConfigSpec.EnumValue fpsDisplaySystemMode = BUILDER.comment("Shows GPU and memory usage onto FPS display").defineEnum("fpsDisplaySystem", (Enum)ChlorideConfig.FPSDisplaySystemMode.OFF);
                ForgeConfigSpec.IntValue fpsDisplayMargin = BUILDER.comment(new String[]{"Configure FPS Display margin", "Give some space between corner and text"}).defineInRange("fpsDisplayMargin", 12, 0, 48);
                ForgeConfigSpec.BooleanValue fpsDisplayShadow = BUILDER.comment(new String[]{"Toggle FPS Display shadow", "In case sometimes you can't see the text"}).define("fpsDisplayShadow", false);
                BUILDER.pop();
                BUILDER.push("quality");
                ForgeConfigSpec.BooleanValue fog = BUILDER.comment(new String[]{"Toggle fog feature", "Fog was a vanilla feature"}).define("fog", true);
                ForgeConfigSpec.BooleanValue blueBand = BUILDER.comment(new String[]{"Clean my skies", "Blue band was a vanilla feature, toggle off will show sky color directly"}).define("blueBand", true);
                ForgeConfigSpec.IntValue cloudsHeight = BUILDER.comment(new String[]{"Raise clouds", "Modify clouds height perfect for a adaptative world experience"}).defineInRange("cloudsHeight", 192, 0, 512);
                ForgeConfigSpec.BooleanValue disableNameTagRender = BUILDER.comment(new String[]{"Do not show me your name", "disables nametag rendering for players and entities"}).define("disableNameTagRendering", false);
                ForgeConfigSpec.EnumValue chunkFadeSpeed = BUILDER.comment(new String[]{"Chunks fade in speed", "This option doesn't affect performance, just changes speed"}).defineEnum("chunkFadeSpeed", (Enum)ChlorideConfig.ChunkFadeSpeed.SLOW);
                BUILDER.push("darkness");
                ForgeConfigSpec.EnumValue darknessMode = BUILDER.comment(new String[]{"Configure Darkness Mode", "Each config changes what is considered 'true darkness'"}).defineEnum("mode", (Enum)ChlorideConfig.DarknessMode.OFF);
                ForgeConfigSpec.BooleanValue darknessOnOverworld = BUILDER.comment("Toggle Darkness on Overworld dimension").define("enableOnOverworld", true);
                ForgeConfigSpec.BooleanValue darknessOnNether = BUILDER.comment("Toggle Darkness on Nether dimension").define("enableOnNether", false);
                ForgeConfigSpec.DoubleValue darknessNetherFogBright = BUILDER.comment("Configure fog brightness on nether when darkness is enabled").defineInRange("netherFogBright", 0.5, 0.0, 1.0);
                ForgeConfigSpec.BooleanValue darknessOnEnd = BUILDER.comment("Toggle Darkness on End dimension").define("enableOnEnd", false);
                ForgeConfigSpec.DoubleValue darknessEndFogBright = BUILDER.comment("Configure fog brightness on nether when darkness is enabled").defineInRange("endFogBright", 0.5, 0.0, 1.0);
                ForgeConfigSpec.BooleanValue darknessByDefault = BUILDER.comment("Toggle Darkness default mode for modded dimensions").define("valueByDefault", false);
                ForgeConfigSpec.ConfigValue darknessDimensionWhiteList = BUILDER.comment(new String[]{"List of all dimensions to use True Darkness", "This option overrides 'valueByDefault' state"}).defineListAllowEmpty(Collections.singletonList("dimensionWhitelist"), Collections::emptyList, s -> s.toString().contains(":"));
                ForgeConfigSpec.BooleanValue darknessOnNoSkyLight = BUILDER.comment("Toggle darkness when dimension has no SkyLight").define("enableOnNoSkyLight", false);
                ForgeConfigSpec.BooleanValue darknessBlockLightOnly = BUILDER.comment(new String[]{"Disables all bright sources of darkness like moon or fog", "Only affects darkness effect"}).define("enableBlockLightOnly", false);
                ForgeConfigSpec.BooleanValue darknessAffectedByMoonPhase = BUILDER.comment("Toggles if moon phases affects darkness in the overworld").define("affectedByMoonPhase", true);
                ForgeConfigSpec.DoubleValue darknessFullMoonBright = BUILDER.comment("Configure max moon brightness level with darkness").defineInRange("fullMoonBright", 0.25, 0.0, 1.0);
                ForgeConfigSpec.DoubleValue darknessNewMoonBright = BUILDER.comment("Configure min moon brightness level with darkness").defineInRange("newMoonBright", 0.0, 0.0, 1.0);
                BUILDER.pop(2);
                BUILDER.push("performance");
                ForgeConfigSpec.EnumValue leavesCulling = BUILDER.comment(new String[]{"Sets culling mode", "Reduces number of visible faces when the neighbor blocks are leaves"}).defineEnum("leavesCulling", (Enum)ChlorideConfig.LeavesCullingMode.OFF);
                ForgeConfigSpec.BooleanValue hideJREMI = BUILDER.comment(new String[]{"Toggles JREI item rendering until searching", "Increases performance a little bit and cleans your screen when you don't want to use it"}).define("hideJREI", false);
                ForgeConfigSpec.BooleanValue fontShadows = BUILDER.comment(new String[]{"Toggles Minecraft Fonts shadows", "Depending of the case may increase performance", "Gives a flat style text"}).define("fontShadows", true);
                BUILDER.push("fastModels");
                ForgeConfigSpec.BooleanValue fastChests = BUILDER.comment(new String[]{"Toggles FastChest feature", "Without flywheel installed or using any backend, it increases FPS significatly on chest rooms"}).define("enableChests", false);
                ForgeConfigSpec.BooleanValue fastBeds = BUILDER.comment("Toggles FastBeds feature").define("enableBeds", false);
                BUILDER.pop();
                BUILDER.push("distanceCulling");
                BUILDER.push("tileEntities");
                ForgeConfigSpec.BooleanValue tileEntityDistanceCulling = BUILDER.comment(new String[]{"Toggles distance culling for Block Entities", "Maybe you use another mod for that :("}).define("enable", true);
                ForgeConfigSpec.IntValue tileEntityCullingDistanceX = BUILDER.comment(new String[]{"Configure horizontal max distance before cull Block entities", "Value is squared, default was 64^2 (or 64x64)"}).defineInRange("cullingMaxDistanceX", 4096, 0, Integer.MAX_VALUE);
                ForgeConfigSpec.IntValue tileEntityCullingDistanceY = BUILDER.comment(new String[]{"Configure vertical max distance before cull Block entities", "Value is raw"}).defineInRange("cullingMaxDistanceY", 32, 0, 512);
                ForgeConfigSpec.ConfigValue tileEntityWhitelist = BUILDER.comment(new String[]{"List of all Block Entities to be ignored by distance culling", "Uses ResourceLocation to identify it", "Example 1: \"minecraft:chest\" - Ignores chests only", "Example 2: \"ae2:all\" - ignores all Block entities from Applied Energetics 2"}).defineListAllowEmpty(Collections.singletonList("whitelist"), Collections.emptyList(), s -> s.toString().contains(":"));
                BUILDER.pop();
                BUILDER.push("entities");
                ForgeConfigSpec.BooleanValue entityDistanceCulling = BUILDER.comment(new String[]{"Toggles distance culling for entities, doesn't affect monsters culling", "Check the options below"}).define("enable", true);
                ForgeConfigSpec.IntValue entityCullingDistanceX = BUILDER.comment(new String[]{"Configure horizontal max distance before cull entities", "Value is squared, default was 64^2 (or 64x64)"}).defineInRange("cullingMaxDistanceX", 4096, 0, Integer.MAX_VALUE);
                ForgeConfigSpec.IntValue entityCullingDistanceY = BUILDER.comment(new String[]{"Configure vertical max distance before cull entities", "Value is raw"}).defineInRange("cullingMaxDistanceY", 32, 0, 512);
                ForgeConfigSpec.ConfigValue entityWhitelist = BUILDER.comment(new String[]{"List of all Entities to be ignored by distance culling", "Uses ResourceLocation to identify it", "Example 1: \"minecraft:bat\" - Ignores bats only", "Example 2: \"alexsmobs:*\" - ignores all entities for alexmobs mod"}).defineListAllowEmpty(Collections.singletonList("whitelist"), Collections.emptyList(), s -> s.toString().contains(":"));
                BUILDER.push("monsters");
                ForgeConfigSpec.BooleanValue monsterDistanceCulling = BUILDER.comment(new String[]{"Toggles distance culling for monsters (or hostile entities, whatever you want to call it), doesn't affect neutral/pacific entities", "Check the options above"}).define("enable", false);
                ForgeConfigSpec.IntValue monsterCullingDistanceX = BUILDER.comment(new String[]{"Configure horizontal max distance before cull monster entities", "Value is squared, default was 64^2 (or 64x64)"}).defineInRange("cullingMaxDistanceX", 16384, 0, Integer.MAX_VALUE);
                ForgeConfigSpec.IntValue monsterCullingDistanceY = BUILDER.comment(new String[]{"Configure vertical max distance before cull monster entities", "Value is raw"}).defineInRange("cullingMaxDistanceY", 64, 0, 512);
                ForgeConfigSpec.ConfigValue monsterWhitelist = BUILDER.comment(new String[]{"List of all monster entities to be ignored by distance culling", "Uses ResourceLocation to identify it", "Example 1: \"minecraft:bat\" - Ignores bats only", "Example 2: \"alexsmobs:*\" - ignores all entities for alexmobs mod"}).defineListAllowEmpty(Collections.singletonList("whitelist"), Collections.emptyList(), s -> s.toString().contains(":"));
                BUILDER.pop(4);
                BUILDER.push("others");
                ForgeConfigSpec.EnumValue borderlessAttachModeF11 = BUILDER.comment("Configure if borderless fullscreen option should be attached to F11 or replace vanilla fullscreen").defineEnum("borderlessAttachModeOnF11", (Enum)ChlorideConfig.AttachMode.ATTACH);
                ForgeConfigSpec.BooleanValue fastLanguageReload = BUILDER.comment(new String[]{"Toggles fast language reload", "Embeddedt points it maybe cause troubles to JEI, so \u00bfwhy not add it as a toggleable option?"}).define("fastLanguageReload", true);
                BUILDER.pop();
                BUILDER.push("dynlights");
                ForgeConfigSpec.EnumValue dynLightSpeed = BUILDER.comment("Configure how fast light whould be updated").defineEnum("updateSpeed", (Enum)ChlorideConfig.DynLightsSpeed.REALTIME);
                ForgeConfigSpec.BooleanValue dynLightsOnEntities = BUILDER.comment("Toggle if Entities should have dynamic lights").define("onEntities", true);
                ForgeConfigSpec.BooleanValue dynLightsOnTileEntities = BUILDER.comment("Toggle if Block Entities should have dynamic lights").define("onTileEntities", true);
                ForgeConfigSpec.BooleanValue dynLightsUpdateOnPositionChange = BUILDER.define("updateOnlyOnPositionChange", true);
                BUILDER.pop();
                SPECS = BUILDER.build();
                SPECS.setConfig((CommentedConfig)configData);
                Chloride.LOGGER.info(IT, "Porting old config");
                ChlorideConfig.fullScreen = (ChlorideConfig.FullScreenMode)((Object)fullScreen.get());
                ChlorideConfig.fpsDisplayMode = (ChlorideConfig.FPSDisplayMode)((Object)fpsDisplayMode.get());
                ChlorideConfig.fpsDisplayAlign = (ChlorideConfig.FPSDisplayAlign)((Object)fpsDisplayGravity.get());
                ChlorideConfig.fpsDisplaySystemMode = (ChlorideConfig.FPSDisplaySystemMode)((Object)fpsDisplaySystemMode.get());
                ChlorideConfig.fpsDisplayMargin = (Integer)fpsDisplayMargin.get();
                ChlorideConfig.fpsDisplayShadow = (Boolean)fpsDisplayShadow.get();
                ChlorideConfig.fog = (Boolean)fog.get();
                ChlorideConfig.blueBand = (Boolean)blueBand.get();
                ChlorideConfig.cloudsHeight = (Integer)cloudsHeight.get();
                ChlorideConfig.disableNameTagRender = (Boolean)disableNameTagRender.get();
                ChlorideConfig.chunkFadeSpeed = (ChlorideConfig.ChunkFadeSpeed)((Object)chunkFadeSpeed.get());
                ChlorideConfig.darknessMode = (ChlorideConfig.DarknessMode)((Object)darknessMode.get());
                ChlorideConfig.darknessOnOverworld = (Boolean)darknessOnOverworld.get();
                ChlorideConfig.darknessOnNether = (Boolean)darknessOnNether.get();
                ChlorideConfig.darknessNetherFogBright = (Double)darknessNetherFogBright.get();
                ChlorideConfig.darknessOnEnd = (Boolean)darknessOnEnd.get();
                ChlorideConfig.darknessEndFogBright = (Double)darknessEndFogBright.get();
                ChlorideConfig.darknessByDefault = (Boolean)darknessByDefault.get();
                ChlorideConfig.darknessDimensionWhiteList = Tools.toId(((List)darknessDimensionWhiteList.get()).toArray(new String[0]));
                ChlorideConfig.darknessOnNoSkyLight = (Boolean)darknessOnNoSkyLight.get();
                ChlorideConfig.darknessBlockLightOnly = (Boolean)darknessBlockLightOnly.get();
                ChlorideConfig.darknessAffectedByMoonPhase = (Boolean)darknessAffectedByMoonPhase.get();
                ChlorideConfig.darknessNewMoonBright = (Double)darknessNewMoonBright.get();
                ChlorideConfig.darknessFullMoonBright = (Double)darknessFullMoonBright.get();
                ChlorideConfig.hideJREMI = (Boolean)hideJREMI.get();
                ChlorideConfig.fontShadows = (Boolean)fontShadows.get();
                ChlorideConfig.leavesCulling = (ChlorideConfig.LeavesCullingMode)((Object)leavesCulling.get());
                ChlorideConfig.fastChests = (Boolean)fastChests.get();
                ChlorideConfig.fastBeds = (Boolean)fastBeds.get();
                ChlorideConfig.tileEntityDistanceCulling = (Boolean)tileEntityDistanceCulling.get();
                ChlorideConfig.tileEntityCullingDistanceX = (Integer)tileEntityCullingDistanceX.get();
                ChlorideConfig.tileEntityCullingDistanceY = (Integer)tileEntityCullingDistanceY.get();
                ChlorideConfig.entityDistanceCulling = (Boolean)entityDistanceCulling.get();
                ChlorideConfig.entityCullingDistanceX = (Integer)entityCullingDistanceX.get();
                ChlorideConfig.entityCullingDistanceY = (Integer)entityCullingDistanceY.get();
                ChlorideConfig.monsterDistanceCulling = (Boolean)monsterDistanceCulling.get();
                ChlorideConfig.monsterCullingDistanceX = (Integer)monsterCullingDistanceX.get();
                ChlorideConfig.monsterCullingDistanceY = (Integer)monsterCullingDistanceY.get();
                ChlorideConfig.entityWhitelist = Tools.toId(((List)entityWhitelist.get()).toArray(new String[0]));
                ChlorideConfig.monsterWhitelist = Tools.toId(((List)monsterWhitelist.get()).toArray(new String[0]));
                ChlorideConfig.tileEntityWhitelist = Tools.toId(((List)tileEntityWhitelist.get()).toArray(new String[0]));
                ChlorideConfig.borderlessAttachModeF11 = (ChlorideConfig.AttachMode)((Object)borderlessAttachModeF11.get());
                ChlorideConfig.fastLanguageReload = (Boolean)fastLanguageReload.get();
                ChlorideConfig.dynLightSpeed = (ChlorideConfig.DynLightsSpeed)((Object)dynLightSpeed.get());
                ChlorideConfig.dynLightsOnEntities = (Boolean)dynLightsOnEntities.get();
                ChlorideConfig.dynLightsOnTileEntities = (Boolean)dynLightsOnTileEntities.get();
                ChlorideConfig.dynLightsUpdateOnPositionChange = (Boolean)dynLightsUpdateOnPositionChange.get();
                Chloride.LOGGER.info(IT, "Chloride config successfully adjusted by old Embeddium++Config");
                configData.close();
                if (!path.delete()) {
                    Chloride.LOGGER.error(IT, "Cannot delete old config file '{}', it requires manual deletion", (Object)path);
                }
            }
            catch (Exception e) {
                if (path.delete()) break block4;
                throw new RuntimeException("Failed to remove corrupted configuration file");
            }
        }
    }
}

