/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketFluidsReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public record PacketGetFluids(BlockPos pos, ResourceKey<Level> type, TypedMap params, boolean fromTablet) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolscontrol", "getfluids");

    public static PacketGetFluids create(FriendlyByteBuf buf) {
        return new PacketGetFluids(buf.m_130135_(), (ResourceKey<Level>)LevelTools.getId((ResourceLocation)buf.m_130281_()), TypedMapTools.readArguments((FriendlyByteBuf)buf), buf.readBoolean());
    }

    public static PacketGetFluids create(BlockPos pos, ResourceKey<Level> type, boolean fromTablet) {
        return new PacketGetFluids(pos, type, TypedMap.EMPTY, fromTablet);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.type.m_135782_());
        TypedMapTools.writeArguments((FriendlyByteBuf)buf, (TypedMap)this.params);
        buf.writeBoolean(this.fromTablet);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            BlockEntity te;
            ServerLevel world = LevelTools.getLevel((Level)player.m_20193_(), this.type);
            if (world.m_46805_(this.pos) && (te = world.m_7702_(this.pos)) instanceof GenericTileEntity) {
                List list = ((GenericTileEntity)te).executeServerCommandList(ProcessorTileEntity.CMD_GETFLUIDS.name(), player, this.params, FluidEntry.class);
                RFToolsCtrlMessages.sendToPlayer(new PacketFluidsReady(this.fromTablet ? null : this.pos, ProcessorTileEntity.CMD_GETFLUIDS.name(), list), player);
            }
        }));
    }

    public static class FluidEntry {
        private final FluidStack fluidStack;
        private final boolean allocated;

        public FluidEntry(FluidStack fluidStack, boolean allocated) {
            this.fluidStack = fluidStack;
            this.allocated = allocated;
        }

        public static FluidEntry fromPacket(FriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                FluidStack fluidStack = null;
                if (buf.readBoolean()) {
                    fluidStack = NetworkTools.readFluidStack((ByteBuf)buf);
                }
                boolean allocated = buf.readBoolean();
                return new FluidEntry(fluidStack, allocated);
            }
            return null;
        }

        public static void toPacket(FriendlyByteBuf buf, FluidEntry item) {
            if (item == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                if (item.getFluidStack() != null) {
                    buf.writeBoolean(true);
                    NetworkTools.writeFluidStack((ByteBuf)buf, (FluidStack)item.getFluidStack());
                } else {
                    buf.writeBoolean(false);
                }
                buf.writeBoolean(item.isAllocated());
            }
        }

        public FluidStack getFluidStack() {
            return this.fluidStack;
        }

        public boolean isAllocated() {
            return this.allocated;
        }

        public static class Serializer
        implements ISerializer<FluidEntry> {
            public Function<FriendlyByteBuf, FluidEntry> getDeserializer() {
                return FluidEntry::fromPacket;
            }

            public BiConsumer<FriendlyByteBuf, FluidEntry> getSerializer() {
                return FluidEntry::toPacket;
            }
        }
    }
}

