/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.EntityCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class RemoveEntitiesCommand {
    private static final SuggestionProvider<CommandSourceStack> sugg = (ctx, builder) -> SharedSuggestionProvider.m_82957_(ForgeRegistries.ENTITY_TYPES.getKeys().stream(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> boolsugg = (ctx, builder) -> SharedSuggestionProvider.m_82970_(Collections.singletonList("force"), (SuggestionsBuilder)builder);
    private static int counter = 0;

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, null))).then(Commands.m_82127_((String)"byType").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(sugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"type")))).then(Commands.m_82129_((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"type"))))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(sugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"type")))).then(Commands.m_82129_((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"type")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"items").executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSourceStack>)ctx, null))).then(Commands.m_82129_((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSourceStack>)ctx, null)))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))).then(Commands.m_82129_((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hostile").executes(RemoveEntitiesCommand::removeMonsters)).then(Commands.m_82129_((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(RemoveEntitiesCommand::removeMonsters)))).then(Commands.m_82127_((String)"regex").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"regex", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RemoveEntitiesCommand.removeEntitiesByRegEx((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"regex")))).then(Commands.m_82129_((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeEntitiesByRegEx((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"regex"))))));
    }

    private static int removeEntities(CommandContext<CommandSourceStack> context, ResourceLocation type) {
        counter = 0;
        List<ServerLevel> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.m_142646_().m_142273_().forEach(entity -> {
            if (type == null) {
                if (!entity.m_8077_()) {
                    RemoveEntitiesCommand.removeEntity(entity);
                }
            } else {
                ResourceLocation resourceLocation = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
                if (resourceLocation != null && resourceLocation.equals((Object)type)) {
                    RemoveEntitiesCommand.removeEntity(entity);
                }
            }
        }));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static int removeEntitiesByRegEx(CommandContext<CommandSourceStack> context, String regex) {
        counter = 0;
        List<ServerLevel> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.m_142646_().m_142273_().forEach(entity -> {
            boolean remove = false;
            if (regex == null) {
                remove = !entity.m_8077_();
            } else {
                ResourceLocation resourceLocation = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
                if (resourceLocation != null) {
                    remove = resourceLocation.toString().matches(regex);
                }
            }
            if (remove) {
                RemoveEntitiesCommand.removeEntity(entity);
            }
        }));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static int removeItems(CommandContext<CommandSourceStack> context, String type) {
        counter = 0;
        List<ServerLevel> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.m_142646_().m_142273_().forEach(entity -> {
            if (entity instanceof ItemEntity) {
                if (type == null) {
                    RemoveEntitiesCommand.removeEntity(entity);
                } else if (entity.m_7755_().getString().contains(type)) {
                    RemoveEntitiesCommand.removeEntity(entity);
                }
            }
        }));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static int removeMonsters(CommandContext<CommandSourceStack> context) {
        counter = 0;
        List<ServerLevel> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.m_142646_().m_142273_().forEach(entity -> {
            if (entity.m_6095_().m_20674_() == MobCategory.MONSTER && !entity.m_8077_()) {
                RemoveEntitiesCommand.removeEntity(entity);
            }
        }));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static void removeEntity(Entity e) {
        e.m_142687_(Entity.RemovalReason.DISCARDED);
        ++counter;
    }

    private static void respond(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandUtils.CreateTextComponent("Removed " + counter + " Entities"), true);
    }
}

