/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.harvest;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.hive.FarmerBee;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.ModList;

public class MinecraftHarvester {
    public static boolean isCropValid(ProductiveBee bee, BlockPos pos) {
        if (pos == null) {
            return false;
        }
        BlockState state = bee.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof CocoaBlock && (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) == 2) {
            return true;
        }
        if (state.m_61138_((Property)SweetBerryBushBlock.f_57244_) && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) == 3) {
            return true;
        }
        if (block instanceof StemGrownBlock) {
            return true;
        }
        if (block instanceof CactusBlock || block instanceof SugarCaneBlock) {
            return bee.m_9236_().m_8055_(pos.m_7495_()).m_60734_().equals(state.m_60734_());
        }
        return block instanceof CropBlock && !((CropBlock)block).m_7370_((LevelReader)bee.m_9236_(), pos, state, false);
    }

    public static void harvestBlock(ProductiveBee bee, BlockPos pos) {
        BlockState cropBlockState = bee.m_9236_().m_8055_(pos);
        Block cropBlock = cropBlockState.m_60734_();
        if (cropBlock instanceof AttachedStemBlock) {
            BlockState fruitBlock = bee.m_9236_().m_8055_(pos.m_121945_((Direction)cropBlockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
            if (fruitBlock.m_60734_() instanceof StemGrownBlock) {
                bee.m_9236_().m_46961_(pos.m_121945_((Direction)cropBlockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), true);
            }
        } else if (cropBlock instanceof SugarCaneBlock || cropBlock instanceof CactusBlock) {
            int i = 0;
            while (i++ < 5 && bee.m_9236_().m_8055_(pos.m_7495_()).m_60734_().equals(cropBlock)) {
                pos = pos.m_7495_();
            }
            bee.m_9236_().m_46961_(pos.m_7494_(), true);
        } else if (cropBlock instanceof SweetBerryBushBlock) {
            int i = (Integer)cropBlockState.m_61143_((Property)SweetBerryBushBlock.f_57244_);
            if (i > 1) {
                int j = 1 + bee.m_9236_().f_46441_.m_188503_(2);
                ItemStack dropStack = cropBlock.m_7397_((BlockGetter)bee.m_9236_(), pos, cropBlockState);
                dropStack.m_41764_(j + (i == 3 ? 1 : 0));
                Block.m_49840_((Level)bee.m_9236_(), (BlockPos)pos, (ItemStack)dropStack);
                bee.m_9236_().m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + bee.m_9236_().f_46441_.m_188501_() * 0.4f);
                bee.m_9236_().m_7731_(pos, (BlockState)cropBlockState.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
            }
        } else if (((Boolean)ProductiveBeesConfig.GENERAL.forceEnableFarmerBeeRightClickHarvest.get()).booleanValue() || ModList.get().isLoaded("right_click_get_crops") || ModList.get().isLoaded("croptopia") || ModList.get().isLoaded("quark") || ModList.get().isLoaded("harvest") || ModList.get().isLoaded("simplefarming") || ModList.get().isLoaded("pamhc2trees") || ModList.get().isLoaded("reap")) {
            FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)bee.m_9236_()), (GameProfile)new GameProfile(FarmerBee.FARMER_BEE_UUID, "farmer_bee"));
            ForgeHooks.onRightClickBlock((Player)fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)new BlockHitResult(bee.m_146892_(), bee.m_6374_(), pos, true));
        } else {
            bee.m_9236_().m_46961_(pos, true);
        }
    }
}

