/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.entity.AbstractBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AmberBlockEntity
extends AbstractBlockEntity {
    private int tickCounter = 0;
    private int meltCounter = 0;
    private static final Map<Integer, Entity> cachedEntities = new HashMap<Integer, Entity>();
    public CompoundTag entityTag = null;

    public AmberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.AMBER.get(), pos, state);
    }

    @Nullable
    public Entity getCachedEntity() {
        if (this.entityTag != null) {
            int key = this.entityTag.hashCode();
            if (!cachedEntities.containsKey(key)) {
                Entity cachedEntity = AmberBlockEntity.createEntity(this.f_58857_, this.entityTag);
                cachedEntities.put(key, cachedEntity);
            }
            return cachedEntities.getOrDefault(key, null);
        }
        return null;
    }

    @Nullable
    public static Entity createEntity(Level world, CompoundTag tag) {
        EntityType type;
        if (tag != null && (type = (EntityType)EntityType.m_20632_((String)tag.m_128461_("entityType")).orElse(null)) != null) {
            try {
                Entity loadedEntity = type.m_20615_(world);
                if (loadedEntity != null) {
                    loadedEntity.m_20258_(tag);
                    return loadedEntity;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        if (this.entityTag != null) {
            tag.m_128365_("EntityData", (Tag)this.entityTag);
        }
        tag.m_128405_("meltCounter", this.meltCounter);
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        if (tag.m_128441_("EntityData")) {
            this.entityTag = tag.m_128469_("EntityData");
        }
        this.meltCounter = tag.m_128441_("meltCounter") ? tag.m_128451_("meltCounter") : 0;
    }

    public void setEntity(Mob target) {
        CompoundTag entityDataTag = target.m_20240_(new CompoundTag());
        entityDataTag.m_128359_("entityType", ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString());
        entityDataTag.m_128359_("lootTable", target.m_5743_().toString());
        if (target.m_8077_()) {
            entityDataTag.m_128359_("name", target.m_7770_().getString());
        } else {
            entityDataTag.m_128359_("name", target.m_7755_().getString());
        }
        this.entityTag = entityDataTag;
        AdvancedBeehiveBlockEntityAbstract.removeIgnoredTags(this.entityTag, true);
        if (this.entityTag.m_128441_("ActiveEffects")) {
            this.entityTag.m_128473_("ActiveEffects");
        }
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, AmberBlockEntity amberBlockEntity) {
        BlockState below = level.m_8055_(blockPos.m_7495_());
        if (level instanceof ServerLevel && ++amberBlockEntity.tickCounter % 21 == 0 && below.m_204336_(BlockTags.f_13087_)) {
            Entity mob;
            int meltingTime;
            amberBlockEntity.meltCounter += 21;
            int n = meltingTime = below.m_60713_(Blocks.f_50684_) ? 400 : 800;
            if (amberBlockEntity.meltCounter > meltingTime && (mob = AmberBlockEntity.createEntity(level, amberBlockEntity.entityTag)) != null) {
                mob.m_6034_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                List players = level.m_45976_(Player.class, new AABB(blockPos).m_82377_(10.0, 5.0, 10.0));
                if (players.size() > 0 && mob instanceof PathfinderMob) {
                    PathfinderMob pathfinderMob = (PathfinderMob)mob;
                    pathfinderMob.m_6703_((LivingEntity)players.iterator().next());
                }
                level.m_7967_(mob);
                level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            }
        }
    }
}

