/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class OrientationTools {
    public static final Direction[] DIRECTION_VALUES = Direction.values();
    public static final Direction[] HORIZONTAL_DIRECTION_VALUES = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static Direction rotateAround(Direction input, Direction.Axis axis) {
        switch (axis) {
            case X: {
                if (input != Direction.WEST && input != Direction.EAST) {
                    return OrientationTools.rotateX(input);
                }
                return input;
            }
            case Y: {
                if (input != Direction.UP && input != Direction.DOWN) {
                    return input.m_122427_();
                }
                return input;
            }
            case Z: {
                if (input != Direction.NORTH && input != Direction.SOUTH) {
                    return OrientationTools.rotateZ(input);
                }
                return input;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    private static Direction rotateX(Direction input) {
        return switch (input) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Direction.DOWN;
            case Direction.SOUTH -> Direction.UP;
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            case Direction.EAST, Direction.WEST -> throw new IllegalStateException("Unable to get X-rotated facing of " + input);
        };
    }

    private static Direction rotateZ(Direction input) {
        return switch (input) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> Direction.DOWN;
            case Direction.WEST -> Direction.UP;
            case Direction.UP -> Direction.EAST;
            case Direction.DOWN -> Direction.WEST;
            case Direction.NORTH, Direction.SOUTH -> throw new IllegalStateException("Unable to get Z-rotated facing of " + input);
        };
    }

    public static Direction getOrientationHoriz(BlockState state) {
        return (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public static Direction getOrientation(BlockState state) {
        return ((BaseBlock)state.m_60734_()).getFrontDirection(state);
    }

    public static Direction determineOrientation(BlockPos pos, LivingEntity entity) {
        return OrientationTools.determineOrientation(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), entity);
    }

    public static Direction determineOrientation(int x, int y, int z, LivingEntity entity) {
        if (Mth.m_14154_((float)((float)entity.m_20185_() - (float)x)) < 2.0f && Mth.m_14154_((float)((float)entity.m_20189_() - (float)z)) < 2.0f) {
            double d0 = entity.m_20186_() + 1.82 - entity.m_6049_();
            if (d0 - (double)y > 2.0) {
                return Direction.UP;
            }
            if ((double)y - d0 > 0.0) {
                return Direction.DOWN;
            }
        }
        int i = (int)((double)(entity.m_146908_() * 4.0f / 360.0f) + 0.5);
        int l = ((double)(entity.m_146908_() * 4.0f / 360.0f) + 0.5 < (double)i ? i - 1 : i) & 3;
        if (l == 0) {
            return Direction.NORTH;
        }
        if (l == 1) {
            return Direction.EAST;
        }
        if (l == 2) {
            return Direction.SOUTH;
        }
        return Direction.WEST;
    }

    public static Direction determineOrientationHoriz(LivingEntity MobEntity) {
        int i = (int)((double)(MobEntity.m_146908_() * 4.0f / 360.0f) + 0.5);
        int l = ((double)(MobEntity.m_146908_() * 4.0f / 360.0f) + 0.5 < (double)i ? i - 1 : i) & 3;
        return switch (l) {
            case 0 -> Direction.NORTH;
            case 1 -> Direction.EAST;
            case 2 -> Direction.SOUTH;
            default -> Direction.WEST;
        };
    }

    public static Direction getTopDirection(Direction rotation) {
        return switch (rotation) {
            case Direction.DOWN -> Direction.SOUTH;
            case Direction.UP -> Direction.NORTH;
            default -> Direction.UP;
        };
    }

    public static Direction getBottomDirection(Direction rotation) {
        return switch (rotation) {
            case Direction.DOWN -> Direction.NORTH;
            case Direction.UP -> Direction.SOUTH;
            default -> Direction.DOWN;
        };
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, @Nullable Entity entityIn) {
        if (entityIn == null) {
            return Direction.UP;
        }
        if (Mth.m_14154_((float)((float)entityIn.m_20185_() - (float)clickedBlock.m_123341_())) < 2.0f && Mth.m_14154_((float)((float)entityIn.m_20189_() - (float)clickedBlock.m_123343_())) < 2.0f) {
            double d0 = entityIn.m_20186_() + (double)entityIn.m_20192_();
            if (d0 - (double)clickedBlock.m_123342_() > 2.0) {
                return Direction.UP;
            }
            if ((double)clickedBlock.m_123342_() - d0 > 0.0) {
                return Direction.DOWN;
            }
        }
        return entityIn.m_6350_().m_122424_();
    }
}

