/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.block.entity.ExcavatingBlockEntityImpl;
import com.tom.createores.recipe.DrillingRecipe;
import com.tom.createores.util.IOBlockType;
import com.tom.createores.util.QueueInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class DrillBlockEntity
extends ExcavatingBlockEntityImpl<DrillingRecipe> {
    private QueueInventory inventory = new QueueInventory();

    public DrillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public <T> LazyOptional<T> getCaps(Capability<T> cap, IOBlockType type) {
        if (type == IOBlockType.ITEM_OUT && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.asCap();
        }
        return super.getCaps(cap, type);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (!clientPacket) {
            this.inventory.load(tag.m_128437_("inv", 10));
        }
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (!clientPacket) {
            tag.m_128365_("inv", (Tag)this.inventory.toTag());
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.inventory.invalidate();
    }

    @Override
    public void dropInv() {
        super.dropInv();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.dropItemStack(this.inventory.getStackInSlot(i));
        }
    }

    @Override
    protected boolean canExtract() {
        return this.inventory.hasSpace() && super.canExtract();
    }

    @Override
    protected void onFinished() {
        ((DrillingRecipe)this.current).getOutput().stream().map(ProcessingOutput::rollOutput).filter(i -> !i.m_41619_()).forEach(this.inventory::add);
        super.onFinished();
    }

    @Override
    protected RecipeType<DrillingRecipe> getRecipeType() {
        return CreateOreExcavation.DRILLING_RECIPES.getRecipeType();
    }
}

