/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.block.entity.interfaces;

import java.util.List;
import java.util.UUID;
import moriyashiine.bewitchment.common.block.entity.ElderChestBlockEntity;
import moriyashiine.bewitchment.common.block.entity.LockableBlockEntity;
import moriyashiine.bewitchment.common.registry.BWTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public interface Lockable {
    public List<UUID> getEntities();

    public UUID getOwner();

    public void setOwner(UUID var1);

    public boolean getModeOnWhitelist();

    public void setModeOnWhitelist(boolean var1);

    public boolean getLocked();

    public void setLocked(boolean var1);

    default public void fromNbtLockable(class_2487 nbt) {
        class_2499 entitiesList = nbt.method_10554("Entities", 10);
        for (int i = 0; i < entitiesList.size(); ++i) {
            this.getEntities().add(UUID.fromString(entitiesList.method_10608(i)));
        }
        if (nbt.method_10545("Owner")) {
            this.setOwner(nbt.method_25926("Owner"));
        }
        this.setModeOnWhitelist(nbt.method_10577("ModeOnWhitelist"));
        this.setLocked(nbt.method_10577("Locked"));
    }

    default public void toNbtLockable(class_2487 nbt) {
        class_2499 entitiesList = new class_2499();
        for (int i = 0; i < this.getEntities().size(); ++i) {
            entitiesList.add((Object)class_2519.method_23256((String)this.getEntities().get(i).toString()));
        }
        nbt.method_10566("Entities", (class_2520)entitiesList);
        if (this.getOwner() != null) {
            nbt.method_25927("Owner", this.getOwner());
        }
        nbt.method_10556("ModeOnWhitelist", this.getModeOnWhitelist());
        nbt.method_10556("Locked", this.getLocked());
    }

    default public class_1269 use(class_1937 world, class_2338 pos, class_1309 user, class_1268 hand) {
        if (user.method_5667().equals(this.getOwner())) {
            class_2586 blockEntity;
            class_1799 stack = user.method_5998(hand);
            if (!this.getLocked() && stack.method_31573(BWTags.SILVER_INGOTS) && (blockEntity = world.method_8321(pos)) instanceof Lockable) {
                Lockable lockable = (Lockable)blockEntity;
                if (!world.field_9236) {
                    class_1657 player;
                    if (!(user instanceof class_1657) || !(player = (class_1657)user).method_7337()) {
                        stack.method_7934(1);
                    }
                    lockable.setModeOnWhitelist(true);
                    lockable.setLocked(true);
                    this.syncLockable(blockEntity);
                    blockEntity.method_5431();
                }
                return class_1269.field_5812;
            }
        }
        if (this.getLocked() && !this.test((class_1297)user)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    default public boolean test(class_1297 entity) {
        if (entity.method_5667().equals(this.getOwner())) {
            return true;
        }
        if (this.getLocked()) {
            if (!this.getEntities().isEmpty()) {
                if (this.getModeOnWhitelist()) {
                    return this.getEntities().contains(entity.method_5667());
                }
                return !this.getEntities().contains(entity.method_5667());
            }
            return false;
        }
        return true;
    }

    default public void syncLockable(class_2586 blockEntity) {
        if (blockEntity instanceof LockableBlockEntity) {
            LockableBlockEntity lockableBlockEntity = (LockableBlockEntity)blockEntity;
            lockableBlockEntity.sync();
        } else if (blockEntity instanceof ElderChestBlockEntity) {
            ElderChestBlockEntity elderChestBlockEntity = (ElderChestBlockEntity)blockEntity;
            elderChestBlockEntity.sync();
        }
    }

    public static class_1269 onUse(class_1937 world, class_2338 pos, class_1309 user, class_1268 hand) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof Lockable) {
            Lockable lockable = (Lockable)class_25862;
            if (lockable.test((class_1297)user)) {
                return lockable.use(world, pos, user, hand);
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }
}

