/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2457;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2773;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class SaltLineBlock
extends class_2248 {
    private static final Map<class_2350, class_265> SIDE_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)SaltLineBlock.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)class_2350.field_11035, (Object)SaltLineBlock.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)class_2350.field_11034, (Object)SaltLineBlock.method_9541((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)class_2350.field_11039, (Object)SaltLineBlock.method_9541((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<class_2350, class_265> NON_SIDE_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_259.method_1084((class_265)SIDE_SHAPES.get(class_2350.field_11043), (class_265)SaltLineBlock.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)class_2350.field_11035, (Object)class_259.method_1084((class_265)SIDE_SHAPES.get(class_2350.field_11035), (class_265)SaltLineBlock.method_9541((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)class_2350.field_11034, (Object)class_259.method_1084((class_265)SIDE_SHAPES.get(class_2350.field_11034), (class_265)SaltLineBlock.method_9541((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)class_2350.field_11039, (Object)class_259.method_1084((class_265)SIDE_SHAPES.get(class_2350.field_11039), (class_265)SaltLineBlock.method_9541((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private static final class_265 DOT_SHAPE = SaltLineBlock.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private final Map<class_2680, class_265> outlineShapes = new HashMap<class_2680, class_265>();

    public SaltLineBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2457.field_11440, (Comparable)class_2773.field_12687)).method_11657((class_2769)class_2457.field_11436, (Comparable)class_2773.field_12687)).method_11657((class_2769)class_2457.field_11437, (Comparable)class_2773.field_12687)).method_11657((class_2769)class_2457.field_11439, (Comparable)class_2773.field_12687));
        for (class_2680 state : this.method_9595().method_11662()) {
            class_265 voxelShape = DOT_SHAPE;
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2773 wireConnection = (class_2773)state.method_11654((class_2769)class_2457.field_11435.get(direction));
                if (wireConnection == class_2773.field_12689) {
                    voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SIDE_SHAPES.get(direction));
                    continue;
                }
                if (wireConnection != class_2773.field_12686) continue;
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)NON_SIDE_SHAPES.get(direction));
            }
            this.outlineShapes.put(state, voxelShape);
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.outlineShapes.get(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_1309 living;
        class_3727 entityShapeContext;
        class_1297 class_12972;
        if (context instanceof class_3727 && (class_12972 = (entityShapeContext = (class_3727)context).method_32480()) instanceof class_1309 && BewitchmentAPI.isWeakToSilver(living = (class_1309)class_12972)) {
            return class_259.method_1077();
        }
        return super.method_9549(state, world, pos, context);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.getPlacementState((class_1922)ctx.method_8045(), ctx.method_8037());
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (direction == class_2350.field_11033) {
            return state;
        }
        if (direction == class_2350.field_11036) {
            return this.getPlacementState((class_1922)world, pos);
        }
        class_2773 wireConnection = this.getConnectionFromNeighbors((class_1922)world, pos, direction, !world.method_8320(pos.method_10084()).method_26212((class_1922)world, pos));
        return wireConnection.method_27855() == ((class_2773)state.method_11654((class_2769)class_2457.field_11435.get(direction))).method_27855() && !SaltLineBlock.isFullyConnected(state) ? (class_2680)state.method_11657((class_2769)class_2457.field_11435.get(direction), (Comparable)wireConnection) : this.getPlacementState((class_1922)world, pos);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2680 placementState;
        if (player.method_31549().field_7476 && (SaltLineBlock.isFullyConnected(state) || SaltLineBlock.isNotConnected(state)) && (placementState = this.getPlacementState((class_1922)world, pos)) != state) {
            world.method_8652(pos, placementState, 3);
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 offset = pos.method_10093(direction);
                if (((class_2773)state.method_11654((class_2769)class_2457.field_11435.get(direction))).method_27855() == ((class_2773)placementState.method_11654((class_2769)class_2457.field_11435.get(direction))).method_27855() || !world.method_8320(offset).method_26212((class_1922)world, offset)) continue;
                world.method_8508(offset, placementState.method_26204(), direction.method_10153());
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        return this.canRunOnTop((class_1922)world, blockPos, world.method_8320(blockPos));
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (!world.field_9236 && !state.method_26184((class_4538)world, pos)) {
            SaltLineBlock.method_9497((class_2680)state, (class_1937)world, (class_2338)pos);
            world.method_8650(pos, false);
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204()) && !world.field_9236) {
            for (class_2350 direction : class_2350.class_2353.field_11064) {
                world.method_8452(pos.method_10093(direction), (class_2248)this);
            }
            this.updateNeighbors(world, pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!moved && !state.method_27852(newState.method_26204())) {
            super.method_9536(state, world, pos, newState, false);
            if (!world.field_9236) {
                for (class_2350 direction : class_2350.values()) {
                    world.method_8452(pos.method_10093(direction), (class_2248)this);
                }
                this.updateNeighbors(world, pos);
            }
        }
    }

    public void method_9517(class_2680 state, class_1936 world, class_2338 pos, int flags, int maxUpdateDepth) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 offset;
            class_2773 wireConnection = (class_2773)state.method_11654((class_2769)class_2457.field_11435.get(direction));
            if (wireConnection == class_2773.field_12687 || world.method_8320((class_2338)mutable.method_25505((class_2382)pos, direction)).method_27852((class_2248)this)) continue;
            mutable.method_10098(class_2350.field_11033);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (!blockState.method_27852(class_2246.field_10282)) {
                offset = mutable.method_10093(direction.method_10153());
                SaltLineBlock.method_9611((class_2680)blockState, (class_2680)blockState.method_26191(direction.method_10153(), world.method_8320(offset), world, (class_2338)mutable, offset), (class_1936)world, (class_2338)mutable, (int)flags, (int)maxUpdateDepth);
            }
            mutable.method_25505((class_2382)pos, direction).method_10098(class_2350.field_11036);
            blockState = world.method_8320((class_2338)mutable);
            if (blockState.method_27852(class_2246.field_10282)) continue;
            offset = mutable.method_10093(direction.method_10153());
            SaltLineBlock.method_9611((class_2680)blockState, (class_2680)blockState.method_26191(direction.method_10153(), world.method_8320(offset), world, (class_2338)mutable, offset), (class_1936)world, (class_2338)mutable, (int)flags, (int)maxUpdateDepth);
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2457.field_11440, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11437)))).method_11657((class_2769)class_2457.field_11436, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11439)))).method_11657((class_2769)class_2457.field_11437, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11440)))).method_11657((class_2769)class_2457.field_11439, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11436)));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2457.field_11440, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11436)))).method_11657((class_2769)class_2457.field_11436, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11437)))).method_11657((class_2769)class_2457.field_11437, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11439)))).method_11657((class_2769)class_2457.field_11439, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11440)));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2457.field_11440, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11439)))).method_11657((class_2769)class_2457.field_11436, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11440)))).method_11657((class_2769)class_2457.field_11437, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11436)))).method_11657((class_2769)class_2457.field_11439, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11437)));
            default -> state;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657((class_2769)class_2457.field_11440, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11437)))).method_11657((class_2769)class_2457.field_11437, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11440)));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657((class_2769)class_2457.field_11436, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11439)))).method_11657((class_2769)class_2457.field_11439, (Comparable)((class_2773)state.method_11654((class_2769)class_2457.field_11436)));
            default -> super.method_9569(state, mirror);
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2457.field_11440, class_2457.field_11437, class_2457.field_11436, class_2457.field_11439});
    }

    private static boolean isFullyConnected(class_2680 state) {
        return ((class_2773)state.method_11654((class_2769)class_2457.field_11440)).method_27855() && ((class_2773)state.method_11654((class_2769)class_2457.field_11437)).method_27855() && ((class_2773)state.method_11654((class_2769)class_2457.field_11436)).method_27855() && ((class_2773)state.method_11654((class_2769)class_2457.field_11439)).method_27855();
    }

    private static boolean isNotConnected(class_2680 state) {
        return !((class_2773)state.method_11654((class_2769)class_2457.field_11440)).method_27855() && !((class_2773)state.method_11654((class_2769)class_2457.field_11437)).method_27855() && !((class_2773)state.method_11654((class_2769)class_2457.field_11436)).method_27855() && !((class_2773)state.method_11654((class_2769)class_2457.field_11439)).method_27855();
    }

    private class_2680 getPlacementState(class_1922 world, class_2338 pos) {
        class_2680 state = this.method_9564();
        boolean notSolid = !world.method_8320(pos.method_10084()).method_26212(world, pos);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (((class_2773)state.method_11654((class_2769)class_2457.field_11435.get(direction))).method_27855()) continue;
            class_2773 wireConnection = this.getConnectionFromNeighbors(world, pos, direction, notSolid);
            state = (class_2680)state.method_11657((class_2769)class_2457.field_11435.get(direction), (Comparable)wireConnection);
        }
        if (!SaltLineBlock.isNotConnected(state) || !SaltLineBlock.isNotConnected(state)) {
            boolean northOrSouth;
            boolean north = ((class_2773)state.method_11654((class_2769)class_2457.field_11440)).method_27855();
            boolean south = ((class_2773)state.method_11654((class_2769)class_2457.field_11437)).method_27855();
            boolean east = ((class_2773)state.method_11654((class_2769)class_2457.field_11436)).method_27855();
            boolean west = ((class_2773)state.method_11654((class_2769)class_2457.field_11439)).method_27855();
            boolean eastOrWest = !north && !south;
            boolean bl = northOrSouth = !east && !west;
            if (!west && eastOrWest) {
                state = (class_2680)state.method_11657((class_2769)class_2457.field_11439, (Comparable)class_2773.field_12689);
            }
            if (!east && eastOrWest) {
                state = (class_2680)state.method_11657((class_2769)class_2457.field_11436, (Comparable)class_2773.field_12689);
            }
            if (!north && northOrSouth) {
                state = (class_2680)state.method_11657((class_2769)class_2457.field_11440, (Comparable)class_2773.field_12689);
            }
            if (!south && northOrSouth) {
                state = (class_2680)state.method_11657((class_2769)class_2457.field_11437, (Comparable)class_2773.field_12689);
            }
        }
        return state;
    }

    private class_2773 getConnectionFromNeighbors(class_1922 blockView, class_2338 blockPos, class_2350 direction, boolean notSolid) {
        class_2338 offset = blockPos.method_10093(direction);
        class_2680 state = blockView.method_8320(offset);
        if (notSolid && this.canRunOnTop(blockView, offset, state) && blockView.method_8320(offset.method_10084()).method_27852((class_2248)this)) {
            return state.method_26206(blockView, offset, direction.method_10153()) ? class_2773.field_12686 : class_2773.field_12689;
        }
        return !state.method_27852((class_2248)this) && (state.method_26212(blockView, offset) || !blockView.method_8320(offset.method_10074()).method_27852((class_2248)this)) ? class_2773.field_12687 : class_2773.field_12689;
    }

    private boolean canRunOnTop(class_1922 world, class_2338 pos, class_2680 floor) {
        return floor.method_26206(world, pos, class_2350.field_11036) || floor.method_27852(class_2246.field_10312);
    }

    private void updateNeighbors(class_1937 world, class_2338 pos) {
        ArrayList<class_2338> toUpdate = new ArrayList<class_2338>();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            toUpdate.add(pos.method_10093(direction));
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 offset = pos.method_10093(direction);
            toUpdate.add(world.method_8320(offset).method_26212((class_1922)world, offset) ? offset.method_10084() : offset.method_10074());
        }
        toUpdate.forEach(blockPos -> {
            if (world.method_8320(blockPos).method_27852((class_2248)this)) {
                world.method_8452(blockPos, (class_2248)this);
                for (class_2350 direction : class_2350.values()) {
                    world.method_8452(blockPos.method_10093(direction), (class_2248)this);
                }
            }
        });
    }
}

