/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.nyctophobia.world.biomes;

import com.finallion.nyctophobia.Nyctophobia;
import com.finallion.nyctophobia.init.NBiomes;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class NBiomeProvider
extends Region {
    public NBiomeProvider(class_2960 name, int overworldWeight) {
        super(name, RegionType.OVERWORLD, overworldWeight);
    }

    public void addBiomes(class_2378<class_1959> registry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
            List<String> configBiomes;
            if (Nyctophobia.config.getBiome((class_2960)new class_2960((String)"nyctophobia", (String)"haunted_forest")).canGenerate) {
                configBiomes = Nyctophobia.config.biomeConfigEntries.get((Object)"haunted_forest").replaceableBiomes;
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.method_29722()), NBiomes.HAUNTED_FOREST_KEY);
                }
            }
            if (Nyctophobia.config.getBiome((class_2960)new class_2960((String)"nyctophobia", (String)"eroded_haunted_forest")).canGenerate) {
                configBiomes = Nyctophobia.config.biomeConfigEntries.get((Object)"eroded_haunted_forest").replaceableBiomes;
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.method_29722()), NBiomes.ERODED_HAUNTED_FOREST_KEY);
                }
            }
            if (Nyctophobia.config.getBiome((class_2960)new class_2960((String)"nyctophobia", (String)"haunted_lakes")).canGenerate) {
                configBiomes = Nyctophobia.config.biomeConfigEntries.get((Object)"haunted_lakes").replaceableBiomes;
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.method_29722()), NBiomes.HAUNTED_LAKES_KEY);
                }
            }
            if (Nyctophobia.config.getBiome((class_2960)new class_2960((String)"nyctophobia", (String)"ancient_dead_coral_reef")).canGenerate) {
                configBiomes = Nyctophobia.config.biomeConfigEntries.get((Object)"ancient_dead_coral_reef").replaceableBiomes;
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.method_29722()), NBiomes.ANCIENT_DEAD_CORAL_REEF_KEY);
                }
            }
            if (Nyctophobia.config.getBiome((class_2960)new class_2960((String)"nyctophobia", (String)"deep_dark_forest")).canGenerate) {
                configBiomes = Nyctophobia.config.biomeConfigEntries.get((Object)"deep_dark_forest").replaceableBiomes;
                for (String configBiome : configBiomes) {
                    builder.replaceBiome(this.parseBiomeKeys(configBiome, registry.method_29722()), NBiomes.DEEP_DARK_FOREST);
                }
            }
        });
    }

    private class_5321<class_1959> parseBiomeKeys(String configBiome, Set<Map.Entry<class_5321<class_1959>, class_1959>> entrySet) {
        List biomeKeys = entrySet.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        for (class_5321 key : biomeKeys) {
            String biomeName = key.method_29177().method_12832();
            if (!biomeName.equals(configBiome)) continue;
            return key;
        }
        Nyctophobia.LOGGER.error("Wrong biome key \"" + configBiome + "\" in config!");
        return null;
    }
}

