/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.universalshops.gui.setup;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.universalshops.gui.BaseShopGui;
import eu.pb4.universalshops.gui.GuiBackground;
import eu.pb4.universalshops.gui.GuiElements;
import eu.pb4.universalshops.other.TextUtil;
import eu.pb4.universalshops.registry.TradeShopBlockEntity;
import eu.pb4.universalshops.trade.PriceHandler;
import eu.pb4.universalshops.trade.StockHandler;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5244;

public class ShopSettingsGui
extends BaseShopGui {
    public ShopSettingsGui(class_3222 player, TradeShopBlockEntity be) {
        super(class_3917.field_17328, player, be, GuiBackground.SETTINGS);
        this.setMainTitle((class_2561)TextUtil.gui("shop.settings", new Object[0]));
        if (!this.hasTexture()) {
            this.setSlot(1, (GuiElementInterface)GuiElements.FILLER);
            this.setSlot(4, (GuiElementInterface)GuiElements.FILLER);
            this.setSlot(7, (GuiElementInterface)GuiElements.FILLER);
        }
        this.setSlot(8, (GuiElementInterface)GuiElements.BACK);
        this.updateStock();
        this.updatePrice();
        this.updateHologram();
        this.updateHopper();
        this.open();
    }

    private void updateHopper() {
        GuiElementBuilder x = new GuiElementBuilder(class_1802.field_8239).setName((class_2561)TextUtil.gui("setup.allow_hoppers", class_5244.method_36134((boolean)this.be.allowHoppers).method_27661().method_27692(class_124.field_1054)).method_27692(class_124.field_1068)).addLoreLine((class_2561)class_2561.method_43473()).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.1", new Object[0])).method_27692(class_124.field_1080)).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"   ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.2", new Object[0])).method_27692(class_124.field_1080)).hideFlags().setCallback((a, type, c, d) -> {
            this.playClickSound();
            this.be.allowHoppers = !this.be.allowHoppers;
            this.updateHopper();
            this.markDirty();
        });
        if (this.be.allowHoppers) {
            x.glow();
        }
        this.setSlot(7, (GuiElementBuilderInterface)x);
    }

    private void updateHologram() {
        this.setSlot(6, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8448).setName((class_2561)TextUtil.gui("setup.hologram", TextUtil.of("hologram_type", this.be.hologramMode.name().toLowerCase(Locale.ROOT), new Object[0]).method_27692(class_124.field_1054)).method_27692(class_124.field_1068)).addLoreLine((class_2561)class_2561.method_43473()).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.1", new Object[0])).method_27692(class_124.field_1080)).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"   ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.2", new Object[0])).method_27692(class_124.field_1080)).hideFlags().setCallback((a, type, c, d) -> {
            int dir = type.shift ? -1 : 1;
            this.playClickSound();
            int size = TradeShopBlockEntity.HologramMode.values().length;
            this.be.hologramMode = TradeShopBlockEntity.HologramMode.values()[(size + this.be.hologramMode.ordinal() + dir) % size];
            this.updateHologram();
            this.markDirty();
        }));
    }

    private void updatePrice() {
        PriceHandler handler = this.be.priceHandler;
        GuiElementBuilder b = GuiElementBuilder.from((class_1799)handler.definition().icon).setName((class_2561)TextUtil.gui("setup.price_type", handler.definition().displayName.method_27661().method_27692(class_124.field_1054)).method_27692(class_124.field_1068));
        if (!handler.canSwitch()) {
            b.addLoreLine((class_2561)TextUtil.gui("setup.cant_change_pricehandler.1", new Object[0]).method_27692(class_124.field_1061));
            b.addLoreLine((class_2561)TextUtil.gui("setup.cant_change_pricehandler.2", new Object[0]).method_27692(class_124.field_1061));
        }
        this.setSlot(0, (GuiElementBuilderInterface)b.addLoreLine((class_2561)class_2561.method_43473()).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.1", new Object[0])).method_27692(class_124.field_1080)).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"   ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.2", new Object[0])).method_27692(class_124.field_1080)).hideFlags().setCallback((a, type, c, d) -> {
            if (!handler.canSwitch()) {
                this.playDismissSound();
                return;
            }
            int dir = type.shift ? -1 : 1;
            this.playClickSound();
            ArrayList<PriceHandler.Definition> types = new ArrayList<PriceHandler.Definition>();
            for (PriceHandler.Definition x : PriceHandler.TYPES) {
                if (!x.canUse(this.player)) continue;
                types.add(x);
            }
            int size = types.size();
            this.be.priceHandler = (PriceHandler)(handler.definition() != PriceHandler.Invalid.DEFINITION ? (PriceHandler.Definition)types.get((size + types.indexOf(handler.definition()) + dir) % size) : PriceHandler.SingleItem.DEFINITION).createInitial(this.be);
            this.updatePrice();
            this.markDirty();
        }));
        this.setSlot(2, handler.getSetupElement());
    }

    private void updateStock() {
        StockHandler handler = this.be.stockHandler;
        GuiElementBuilder b = GuiElementBuilder.from((class_1799)handler.definition().icon).setName((class_2561)TextUtil.gui("setup.stock_type", handler.definition().displayName.method_27661().method_27692(class_124.field_1054)).method_27692(class_124.field_1068));
        if (!handler.canSwitch()) {
            b.addLoreLine((class_2561)TextUtil.gui("setup.cant_change_pricehandler.1", new Object[0]).method_27692(class_124.field_1061));
            b.addLoreLine((class_2561)TextUtil.gui("setup.cant_change_pricehandler.2", new Object[0]).method_27692(class_124.field_1061));
        }
        this.setSlot(3, (GuiElementBuilderInterface)b.addLoreLine((class_2561)class_2561.method_43473()).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.1", new Object[0])).method_27692(class_124.field_1080)).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"   ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.2", new Object[0])).method_27692(class_124.field_1080)).hideFlags().setCallback((a, type, c, d) -> {
            if (!handler.canSwitch()) {
                this.playDismissSound();
                return;
            }
            int dir = type.shift ? -1 : 1;
            this.playClickSound();
            ArrayList<StockHandler.Definition> types = new ArrayList<StockHandler.Definition>();
            for (StockHandler.Definition x : StockHandler.TYPES) {
                if (!x.canUse(this.player)) continue;
                types.add(x);
            }
            int size = types.size();
            this.be.stockHandler = (StockHandler)(handler.definition() != StockHandler.Invalid.DEFINITION ? (StockHandler.Definition)types.get((size + types.indexOf(handler.definition()) + dir) % size) : StockHandler.SingleItem.DEFINITION).createInitial(this.be);
            this.updateStock();
            this.markDirty();
        }));
        this.setSlot(5, handler.getSetupElement());
    }
}

