/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.command.suggestion.SuggestionProviders;
import org.popcraft.chunky.event.task.GenerationTaskFinishEvent;
import org.popcraft.chunky.event.task.GenerationTaskUpdateEvent;
import org.popcraft.chunky.listeners.bossbar.BossBarTaskFinishListener;
import org.popcraft.chunky.listeners.bossbar.BossBarTaskUpdateListener;
import org.popcraft.chunky.platform.FabricPlayer;
import org.popcraft.chunky.platform.FabricSender;
import org.popcraft.chunky.platform.FabricServer;
import org.popcraft.chunky.platform.impl.GsonConfig;

public class ChunkyFabric
implements ModInitializer {
    private Chunky chunky;
    private final Map<class_2960, class_3213> bossBars = new ConcurrentHashMap<class_2960, class_3213>();

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve("chunky/config.json");
            this.chunky = new Chunky(new FabricServer(this, minecraftServer), new GsonConfig(configPath));
            if (this.chunky.getConfig().getContinueOnRestart()) {
                this.chunky.getCommands().get("continue").execute(this.chunky.getServer().getConsole(), CommandArguments.empty());
            }
            this.chunky.getEventBus().subscribe(GenerationTaskUpdateEvent.class, new BossBarTaskUpdateListener(this.bossBars));
            this.chunky.getEventBus().subscribe(GenerationTaskFinishEvent.class, new BossBarTaskFinishListener(this.bossBars));
            FabricLoader.getInstance().getEntrypointContainers("chunky", ModInitializer.class).forEach(entryPoint -> ((ModInitializer)entryPoint.getEntrypoint()).onInitialize());
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(minecraftServer -> {
            if (this.chunky != null) {
                this.chunky.disable();
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chunky").requires(serverCommandSource -> {
                if (serverCommandSource.method_9211().method_3724()) {
                    return true;
                }
                return new FabricSender((class_2168)serverCommandSource).hasPermission("chunky.command", true);
            })).executes(context -> {
                FabricSender sender;
                class_1297 patt3973$temp = ((class_2168)context.getSource()).method_9228();
                if (patt3973$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt3973$temp;
                    sender = new FabricPlayer(player);
                } else {
                    sender = new FabricSender((class_2168)context.getSource());
                }
                Map<String, ChunkyCommand> commands = this.chunky.getCommands();
                String input = context.getInput().substring(((ParsedCommandNode)context.getLastChild().getNodes().get(0)).getRange().getStart());
                String[] tokens = input.split(" ");
                String subCommand = tokens.length > 1 && commands.containsKey(tokens[1]) ? tokens[1] : "help";
                CommandArguments arguments = tokens.length > 2 ? CommandArguments.of(Arrays.copyOfRange(tokens, 2, tokens.length)) : CommandArguments.empty();
                commands.get(subCommand).execute(sender, arguments);
                return 1;
            });
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"cancel"), class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"center"), class_2170.method_9244((String)"x", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"z", (ArgumentType)StringArgumentType.word())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"confirm")});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"continue"), class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"corners"), class_2170.method_9244((String)"x1", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"z1", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"x2", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"z2", (ArgumentType)StringArgumentType.word())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"help"), class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"pattern"), class_2170.method_9244((String)"pattern", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.PATTERNS), class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"pause"), class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"progress")});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"quiet"), class_2170.method_9244((String)"interval", (ArgumentType)IntegerArgumentType.integer())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"radius"), class_2170.method_9244((String)"radius", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"radius", (ArgumentType)StringArgumentType.word())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"reload"), class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"selection")});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"shape"), class_2170.method_9244((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES)});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"silent")});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"spawn")});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"start"), class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288()), class_2170.method_9244((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES), class_2170.method_9244((String)"centerX", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"centerZ", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"radiusX", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"radiusZ", (ArgumentType)StringArgumentType.word())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"trim"), class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288()), class_2170.method_9244((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES), class_2170.method_9244((String)"centerX", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"centerZ", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"radiusX", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"radiusZ", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"trimMode", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.TRIM_MODES), class_2170.method_9244((String)"inhabited", (ArgumentType)StringArgumentType.word())});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"worldborder")});
            this.registerArguments(command, new ArgumentBuilder[]{class_2170.method_9247((String)"world"), class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288())});
            LiteralArgumentBuilder borderCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"border").requires(serverCommandSource -> this.chunky != null && this.chunky.getCommands().containsKey("border"))).executes(command.getCommand());
            this.registerArguments(borderCommand, new ArgumentBuilder[]{class_2170.method_9247((String)"add"), class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288()), class_2170.method_9244((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES), class_2170.method_9244((String)"centerX", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"centerZ", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"radiusX", (ArgumentType)StringArgumentType.word()), class_2170.method_9244((String)"radiusZ", (ArgumentType)StringArgumentType.word())});
            this.registerArguments(borderCommand, new ArgumentBuilder[]{class_2170.method_9247((String)"bypass"), class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305())});
            this.registerArguments(borderCommand, new ArgumentBuilder[]{class_2170.method_9247((String)"help")});
            this.registerArguments(borderCommand, new ArgumentBuilder[]{class_2170.method_9247((String)"list")});
            this.registerArguments(borderCommand, new ArgumentBuilder[]{class_2170.method_9247((String)"load"), class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288())});
            this.registerArguments(borderCommand, new ArgumentBuilder[]{class_2170.method_9247((String)"remove"), class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288())});
            this.registerArguments(borderCommand, new ArgumentBuilder[]{class_2170.method_9247((String)"wrap"), class_2170.method_9244((String)"wrap", (ArgumentType)StringArgumentType.word())});
            this.registerArguments(command, new ArgumentBuilder[]{borderCommand});
            dispatcher.register(command);
        });
    }

    @SafeVarargs
    private <S> void registerArguments(LiteralArgumentBuilder<S> command, ArgumentBuilder<S, ?> ... arguments) {
        for (int i = arguments.length - 1; i > 0; --i) {
            arguments[i - 1].then(arguments[i].executes(command.getCommand()));
        }
        command.then(arguments[0].executes(command.getCommand()));
    }

    public Chunky getChunky() {
        return this.chunky;
    }
}

