/*
 * Decompiled with CFR 0.152.
 */
package nourl.mythicmetalsdecorations.blocks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.owo.itemgroup.OwoItemSettings;
import io.wispforest.owo.util.TagInjector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5172;
import net.minecraft.class_7923;
import nourl.mythicmetalsdecorations.MythicMetalsDecorations;
import nourl.mythicmetalsdecorations.blocks.chest.MythicChestBlock;
import nourl.mythicmetalsdecorations.blocks.chest.MythicChests;
import nourl.mythicmetalsdecorations.item.RegalSet;
import nourl.mythicmetalsdecorations.utils.RegHelper;

public class MythicDecorationSet {
    private final class_5172 chain;
    private final MythicChestBlock chest;
    private final RegalSet regalSet;
    private final class_1738 crown;
    private final String name;
    private final boolean fireproof;
    private final Multimap<class_2248, class_2960> miningLevels;
    public static final Multimap<String, MythicChestBlock> CHEST_MAP = HashMultimap.create();

    private MythicDecorationSet(String name, class_5172 chain, MythicChestBlock chest, RegalSet regalSet, class_1738 crown, boolean fireproof, Multimap<class_2248, class_2960> miningLevels) {
        this.name = name;
        this.regalSet = regalSet;
        this.crown = crown;
        this.fireproof = fireproof;
        this.chain = chain;
        this.chest = chest;
        this.miningLevels = miningLevels;
    }

    private void register() {
        if (this.chain != null) {
            RegHelper.chain(this.name + "_chain", (class_2248)this.chain, this.fireproof);
        }
        if (this.chest != null) {
            RegHelper.chest(this.name + "_chest", (class_2248)this.chest, this.fireproof, MythicMetalsDecorations.MYTHICMETALS_DECOR);
            CHEST_MAP.put((Object)this.name, (Object)this.chest);
        }
        if (this.regalSet != null) {
            this.regalSet.register(this.name);
        }
        if (this.crown != null) {
            RegHelper.item(this.name + "_crown", (class_1792)this.crown);
        }
        this.miningLevels.forEach((block, level) -> TagInjector.inject((class_2378)class_7923.field_41175, (class_2960)level, (Object[])new class_2248[]{block}));
    }

    public class_5172 getChain() {
        return this.chain;
    }

    public MythicChestBlock getChest() {
        return this.chest;
    }

    public class_1738 getCrown() {
        return this.crown;
    }

    public static class Builder {
        private static final List<MythicDecorationSet> toBeRegistered = new ArrayList<MythicDecorationSet>();
        private final String name;
        private final boolean fireproof;
        private class_5172 chain = null;
        private MythicChestBlock chest = null;
        private float currentHardness = -1.0f;
        private float currentResistance = -1.0f;
        private final Multimap<class_2248, class_2960> miningLevels = HashMultimap.create();
        private final Consumer<FabricBlockSettings> settingsProcessor = fabricBlockSettings -> {};
        private final class_2960 PICKAXE = new class_2960("mineable/pickaxe");
        private RegalSet regalSet = null;
        private class_1738 crown = null;

        private Builder(String name, boolean fireproof) {
            this.name = name;
            this.fireproof = fireproof;
        }

        public static Builder begin(String name, boolean fireproof) {
            return new Builder(name, fireproof);
        }

        public static void register() {
            toBeRegistered.forEach(MythicDecorationSet::register);
            toBeRegistered.clear();
        }

        private static FabricBlockSettings blockSettings(float hardness, float resistance, class_2498 sounds) {
            return FabricBlockSettings.create().strength(hardness, resistance).sounds(sounds).requiresTool();
        }

        public Builder createDefaultSet(float strength, class_2960 miningLevel, int slots) {
            return this.strength(strength).createChain(miningLevel).createChest(slots, miningLevel);
        }

        public Builder createDefaultSet(float strength, float resistance, class_2960 miningLevel, int slots) {
            return this.strength(strength, resistance).createChain(miningLevel).createChest(slots, miningLevel);
        }

        public Builder sounds(class_2498 sounds) {
            return this;
        }

        public Builder strength(float strength) {
            return this.strength(strength, strength + 1.0f);
        }

        public Builder strength(float hardness, float resistance) {
            this.currentHardness = hardness;
            this.currentResistance = resistance;
            return this;
        }

        public Builder createChain(class_2960 miningLevel) {
            FabricBlockSettings settings = Builder.blockSettings(this.currentHardness, this.currentResistance, class_2498.field_24119);
            this.settingsProcessor.accept(settings);
            this.chain = new class_5172((class_4970.class_2251)settings);
            this.miningLevels.put((Object)this.chain, (Object)miningLevel);
            this.miningLevels.put((Object)this.chain, (Object)this.PICKAXE);
            return this;
        }

        public Builder createChest(int slots, class_2960 miningLevel) {
            FabricBlockSettings settings = Builder.blockSettings(this.currentHardness, this.currentResistance, class_2498.field_11533);
            this.settingsProcessor.accept(settings);
            this.chest = new MythicChestBlock(this.name, (class_4970.class_2251)settings, () -> MythicChests.MYTHIC_CHEST_BLOCK_ENTITY_TYPE, slots);
            this.miningLevels.put((Object)this.chest, (Object)miningLevel);
            this.miningLevels.put((Object)this.chest, (Object)this.PICKAXE);
            return this;
        }

        public Builder createRegalSet(class_1741 material) {
            this.regalSet = new RegalSet(material);
            return this;
        }

        public Builder createCrown(class_1741 material, boolean fireproof) {
            this.crown = fireproof ? new class_1738(material, class_1738.class_8051.field_41934, (class_1792.class_1793)new OwoItemSettings().group(MythicMetalsDecorations.MYTHICMETALS_DECOR).tab(2).fireproof()) : new class_1738(material, class_1738.class_8051.field_41934, (class_1792.class_1793)new OwoItemSettings().group(MythicMetalsDecorations.MYTHICMETALS_DECOR).tab(2));
            return this;
        }

        public Builder createCrown(class_1741 material, Consumer<OwoItemSettings> settingsProcessor) {
            OwoItemSettings settings = new OwoItemSettings().group(MythicMetalsDecorations.MYTHICMETALS_DECOR).tab(2);
            settingsProcessor.accept(settings);
            this.crown = new class_1738(material, class_1738.class_8051.field_41934, (class_1792.class_1793)settings);
            return this;
        }

        public MythicDecorationSet finish() {
            MythicDecorationSet set = new MythicDecorationSet(this.name, this.chain, this.chest, this.regalSet, this.crown, this.fireproof, this.miningLevels);
            toBeRegistered.add(set);
            return set;
        }
    }
}

