/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import tfar.davespotioneering.PotionUtils2;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.platform.Services;

public class CGauntletItem
extends class_1829 {
    public static final String ACTIVE = "active";
    public static final String ACTIVE_POTION = "activePotionIndex";
    public static final String BLAZE = "blaze";
    public static final String INFO = "info";
    public static final String COOLDOWNS = "potionCooldownMap";
    public static final String POTIONS = "potions";
    public static final int SLOTS = 6;
    public static final int C_LINES = 3;

    public CGauntletItem(class_1832 $$0, int $$1, float $$2, class_1792.class_1793 $$3) {
        super($$0, $$1, $$2, $$3);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        tooltip.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".hold_shift.desc")));
        if (class_437.method_25442()) {
            tooltip.add((class_2561)this.getShiftDescription().method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".hold_ctrl.desc")));
        if (class_437.method_25441()) {
            for (int i = 0; i < 3; ++i) {
                tooltip.add((class_2561)this.getCtrlDescriptions(i).method_27692(class_124.field_1080));
            }
        }
        if (!stack.method_7985()) {
            return;
        }
        class_2499 nbts = stack.method_7969().method_10562(INFO).method_10554(POTIONS, 10);
        if (nbts.isEmpty()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43470((String)" "));
        for (class_2520 instance : nbts) {
            PotionUtils2.addPotionTooltip((class_2487)instance, tooltip, 0.125f);
            tooltip.add((class_2561)class_2561.method_43470((String)"----------------"));
        }
    }

    public boolean method_31567(class_1799 stack) {
        class_2487 info = stack.method_7948().method_10562(INFO);
        double blaze = info.method_10550(BLAZE);
        return blaze > 0.0;
    }

    public boolean method_7873(class_1799 stack, class_1309 victim, class_1309 attacker) {
        if (stack.method_7909() instanceof CGauntletItem) {
            class_2487 info = stack.method_7948().method_10562(INFO);
            boolean active = stack.method_7969().method_10577(ACTIVE);
            if (active) {
                class_2487 activeEffect = CGauntletItem.getActiveEffectFromNBT(info);
                if (attacker instanceof class_1657) {
                    class_1657 player = (class_1657)attacker;
                    int cooldown = CGauntletItem.getCooldownFromPotionByIndex(info.method_10550(ACTIVE_POTION), player);
                    if (activeEffect != null && cooldown <= 0 && info.method_10550(BLAZE) > 0) {
                        for (class_1293 effectInstance : class_1844.method_8066((class_2487)activeEffect)) {
                            victim.method_6092(new class_1293(effectInstance));
                        }
                        int blaze = info.method_10550(BLAZE);
                        info.method_10569(BLAZE, --blaze);
                        if (blaze <= 0) {
                            stack.method_7969().method_10556(ACTIVE, false);
                        }
                        CGauntletItem.setPotionCooldownByIndex(info.method_10550(ACTIVE_POTION), Services.PLATFORM.gauntletCooldown(), player);
                    }
                }
            }
        }
        return super.method_7873(stack, victim, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 playerIn, class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        if (playerIn.method_5715()) {
            boolean active = stack.method_7948().method_10577(ACTIVE);
            int blaze = CGauntletItem.getBlaze(stack);
            if (!world.field_9236 && (blaze > 0 || active)) {
                stack.method_7948().method_10556(ACTIVE, !active);
                world.method_43128(null, playerIn.method_23317(), playerIn.method_23318(), playerIn.method_23321(), active ? ModSoundEvents.GAUNTLET_TURNING_OFF : ModSoundEvents.GAUNTLET_TURNING_ON, class_3419.field_15248, 0.5f, 1.0f);
            }
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public boolean method_7846() {
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public class_5250 getShiftDescription() {
        return class_2561.method_43471((String)(this.method_7876() + ".shift.desc"));
    }

    public class_5250 getCtrlDescription() {
        return class_2561.method_43471((String)(this.method_7876() + ".ctrl.desc"));
    }

    public static int getBlaze(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        int blaze = 0;
        if (tag != null) {
            class_2487 info = tag.method_10562(INFO);
            blaze = info.method_10550(BLAZE);
        }
        return blaze;
    }

    public int method_31569(class_1799 stack) {
        int blaze = CGauntletItem.getBlaze(stack);
        return 13 * blaze / 32;
    }

    public int method_31571(class_1799 stack) {
        return class_124.field_1065.method_532();
    }

    public static class_1842[] getVisibleEffects(class_2487 info) {
        class_2499 nbts = info.method_10554(POTIONS, 10);
        if (nbts.isEmpty()) {
            return null;
        }
        int index = info.method_10550(ACTIVE_POTION);
        class_2487 tag = nbts.method_10602(index);
        if (--index < 0) {
            index = 5;
        }
        class_2487 pre = nbts.method_10602(index);
        index += 2;
        class_2487 post = nbts.method_10602(index %= 6);
        class_1842 activePotion = class_1844.method_8057((class_2487)tag);
        class_1842 prePotion = class_1844.method_8057((class_2487)pre);
        class_1842 postPotion = class_1844.method_8057((class_2487)post);
        return new class_1842[]{activePotion, prePotion, postPotion};
    }

    public static void tickCooldownsCommon(class_3222 player) {
        int[] cooldowns = Services.PLATFORM.getGauntletCooldowns((class_1657)player);
        int[] newCooldowns = Arrays.copyOf(cooldowns, cooldowns.length);
        for (int i = 0; i < newCooldowns.length; ++i) {
            int cooldown = newCooldowns[i];
            if (cooldown <= 0) continue;
            newCooldowns[i] = --cooldown;
        }
        if (!Arrays.equals(cooldowns, newCooldowns)) {
            Services.PLATFORM.setGauntletCooldowns((class_1657)player, newCooldowns);
            Services.PLATFORM.syncGauntletCooldowns((class_1657)player, newCooldowns);
        }
    }

    public static class_2487 getActiveEffectFromNBT(class_2487 info) {
        class_2499 nbts = info.method_10554(POTIONS, 10);
        if (nbts.isEmpty()) {
            return null;
        }
        int index = info.method_10550(ACTIVE_POTION);
        return nbts.method_10602(index);
    }

    public static void cycleGauntletForward(class_1657 player) {
        if (player == null) {
            return;
        }
        class_2487 info = player.method_6047().method_7948().method_10562(INFO);
        class_2499 nbts = info.method_10554(POTIONS, 10);
        if (nbts.isEmpty()) {
            return;
        }
        int index = info.method_10550(ACTIVE_POTION);
        if (++index > 5) {
            index = 0;
        }
        info.method_10569(ACTIVE_POTION, index);
    }

    public static void cycleGauntletBackward(class_1657 player) {
        if (player == null) {
            return;
        }
        class_2487 info = player.method_6047().method_7948().method_10562(INFO);
        class_2499 nbts = info.method_10554(POTIONS, 10);
        if (nbts.isEmpty()) {
            return;
        }
        int index = info.method_10550(ACTIVE_POTION);
        if (--index < 0) {
            index = 5;
        }
        info.method_10569(ACTIVE_POTION, index);
    }

    public static void setPotionCooldownByIndex(int index, int cooldown, class_1657 living) {
        int[] cooldowns = Services.PLATFORM.getGauntletCooldowns(living);
        if (cooldowns.length == 0) {
            cooldowns = new int[6];
        }
        cooldowns[index] = cooldown;
        Services.PLATFORM.setGauntletCooldowns(living, cooldowns);
    }

    public static int getCooldownFromPotionByIndex(int indexOfPotion, class_1657 living) {
        int[] cooldowns = Services.PLATFORM.getGauntletCooldowns(living);
        if (cooldowns.length == 0) {
            return 0;
        }
        return cooldowns[indexOfPotion];
    }

    public class_5250 getCtrlDescriptions(int i) {
        return class_2561.method_43471((String)(this.method_7876() + i + ".ctrl.desc"));
    }
}

