/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import tfar.davespotioneering.client.HudPreset;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.item.CGauntletItem;
import tfar.davespotioneering.mixin.GuiAccess;
import tfar.davespotioneering.platform.Services;

public class GauntletHUDCommon {
    public static final class_2960 GAUNTLET_ICON_LOC = new class_2960("davespotioneering", "textures/gauntlet_icons/");
    public static final class_310 mc = class_310.method_1551();
    static final int TEX_HEIGHT = 41;
    static final int TEX_WIDTH = 121;
    static final class_2960 hud = GauntletHUDCommon.getGauntletIconLoc("hud");
    static final int maxCooldown = 40;
    public static int[] cooldowns = new int[6];
    static int cooldown = 40;
    static boolean forwardCycle = false;
    static class_1842 activePotion = null;
    static class_1842 prePotion = null;
    static class_1842 postPotion = null;
    static boolean backwardCycle = false;

    public static class_2960 getGauntletIconLoc(String fileName) {
        return new class_2960(GAUNTLET_ICON_LOC.method_12836(), GAUNTLET_ICON_LOC.method_12832() + fileName + ".png");
    }

    public static void init(class_1842 activePotion, class_1842 prePotion, class_1842 postPotion) {
        GauntletHUDCommon.activePotion = activePotion;
        GauntletHUDCommon.prePotion = prePotion;
        GauntletHUDCommon.postPotion = postPotion;
    }

    static int getScaledCooldown(float pixels, float cooldown) {
        float totalCooldown = Services.PLATFORM.gauntletCooldown();
        if (totalCooldown != 0.0f) {
            float result = cooldown * pixels / totalCooldown;
            return Math.round(result);
        }
        return 0;
    }

    static void renderPotion(class_1842 potion, class_332 matrixStack, int x, int y, int cooldown) {
        if (potion == null) {
            return;
        }
        if (potion.method_8049().isEmpty()) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (potion.method_8049().size() > 1) {
            String name = class_7923.field_41179.method_10221((Object)potion).toString();
            class_2960 resourceLocation = name.contains("turtle_master") ? GauntletHUDCommon.getGauntletIconLoc("turtle_master") : (mc.method_1478().method_14486(GauntletHUDCommon.getGauntletIconLoc(name)).isPresent() ? GauntletHUDCommon.getGauntletIconLoc(name) : GauntletHUDCommon.getGauntletIconLoc("unknown"));
            matrixStack.method_25291(resourceLocation, x, y, 0, 0.0f, 0.0f, 18, 18, 18, 18);
        } else {
            class_1291 effect = ((class_1293)potion.method_8049().get(0)).method_5579();
            class_1058 sprite = mc.method_18505().method_18663(effect);
            matrixStack.method_25298(x, y, 0, 18, 18, sprite);
        }
        if (cooldown > 0) {
            if (Services.PLATFORM.isDevelopmentEnvironment()) {
                matrixStack.method_25303(GauntletHUDCommon.mc.field_1772, String.valueOf(cooldown), x, y - 20, 0xFF0000);
            }
            int w = 18;
            int scale = GauntletHUDCommon.getScaledCooldown(w, cooldown);
            matrixStack.method_25294(x, y + w - scale, x + 18, y + w, Integer.MAX_VALUE);
        }
    }

    public static void render(class_329 gui, class_332 guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        int hudX = Services.PLATFORM.gauntletHudX();
        int hudY = Services.PLATFORM.gauntletHudY();
        class_746 player = GauntletHUDCommon.mc.field_1724;
        if (player == null) {
            return;
        }
        class_1799 g = player.method_6047();
        if (g.method_7909() instanceof CGauntletItem) {
            int yOffset;
            class_2487 info = player.method_6047().method_7948().method_10562("info");
            class_1842[] potions = CGauntletItem.getVisibleEffects(info);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (Services.PLATFORM.preset() == HudPreset.ABOVE_HOTBAR) {
                hudX = (screenWidth - 121) / 2;
                hudY = screenHeight - Math.min(Services.PLATFORM.leftHeight(gui), Services.PLATFORM.rightHeight(gui)) - 41;
                if (((GuiAccess)gui).getToolHighlightTimer() > 0) {
                    hudY -= 10;
                }
            }
            int xFixed = hudX;
            int yFixed = hudY;
            if (forwardCycle) {
                yOffset = 2;
                if (--cooldown <= 0) {
                    mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                    forwardCycle = false;
                    cooldown = 40;
                }
            } else if (backwardCycle) {
                yOffset = 1;
                if (--cooldown <= 0) {
                    mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                    backwardCycle = false;
                    cooldown = 40;
                }
            } else {
                yOffset = 0;
            }
            guiGraphics.method_25291(hud, xFixed, yFixed, 0, 0.0f, (float)(1 + 43 * yOffset), 121, 41, 128, 128);
            int active = info.method_10550("activePotionIndex");
            int prev = active > 0 ? active - 1 : 5;
            int next = active < 5 ? active + 1 : 0;
            GauntletHUDCommon.renderPotion(prePotion, guiGraphics, xFixed + 3, yFixed + 21, cooldowns[prev]);
            GauntletHUDCommon.renderPotion(activePotion, guiGraphics, xFixed + 51, yFixed + 5, cooldowns[active]);
            GauntletHUDCommon.renderPotion(postPotion, guiGraphics, xFixed + 99, yFixed + 21, cooldowns[next]);
            if (potions == null) {
                GauntletHUDCommon.init(null, null, null);
                return;
            }
            GauntletHUDCommon.init(potions[0], potions[1], potions[2]);
        }
    }

    public static void forwardCycle() {
        forwardCycle = true;
    }

    public static void backwardCycle() {
        backwardCycle = true;
    }
}

