/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1708;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_1828;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2586;
import net.minecraft.class_2589;
import net.minecraft.class_2591;
import net.minecraft.class_3414;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.block.CLayeredReinforcedCauldronBlock;
import tfar.davespotioneering.block.ModCauldronInteractions;
import tfar.davespotioneering.duck.BrewingStandDuck;
import tfar.davespotioneering.init.ModBlockEntityTypes;
import tfar.davespotioneering.init.ModBlocks;
import tfar.davespotioneering.init.ModEffects;
import tfar.davespotioneering.init.ModItems;
import tfar.davespotioneering.init.ModMenuTypes;
import tfar.davespotioneering.init.ModParticleTypes;
import tfar.davespotioneering.init.ModPotions;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.item.CUmbrellaItem;
import tfar.davespotioneering.menu.CAdvancedBrewingStandMenu;
import tfar.davespotioneering.mixin.BlockEntityTypeAcces;
import tfar.davespotioneering.mixin.BrewingStandContainerAccess;
import tfar.davespotioneering.platform.Services;

public class DavesPotioneering {
    public static final String MOD_NAME = "Dave's Potioneering";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Dave's Potioneering");
    public static final String MODID = "davespotioneering";
    public static final boolean isFabric = Services.PLATFORM.getPlatformName().equals("Fabric");

    public static void earlySetup() {
        Services.PLATFORM.superRegister(ModBlocks.class, class_7923.field_41175, class_2248.class);
        Services.PLATFORM.superRegister(ModEffects.class, class_7923.field_41174, class_1291.class);
        Services.PLATFORM.superRegister(ModItems.class, class_7923.field_41178, class_1792.class);
        Services.PLATFORM.superRegister(ModBlockEntityTypes.class, class_7923.field_41181, class_2591.class);
        Services.PLATFORM.superRegister(ModMenuTypes.class, class_7923.field_41187, class_3917.class);
        Services.PLATFORM.superRegister(ModPotions.class, class_7923.field_41179, class_1842.class);
        Services.PLATFORM.superRegister(ModParticleTypes.class, class_7923.field_41180, class_2396.class);
        Services.PLATFORM.superRegister(ModSoundEvents.class, class_7923.field_41172, class_3414.class);
    }

    public static void commonSetup() {
        HashSet<class_2248> newSet = new HashSet<class_2248>(((BlockEntityTypeAcces)class_2591.field_16412).getValidBlocks());
        newSet.add(ModBlocks.MAGIC_LECTERN);
        ((BlockEntityTypeAcces)class_2591.field_16412).setValidBlocks(newSet);
    }

    public static void onEat(class_1657 player, class_1799 stack) {
        List mobEffectInstances = class_1844.method_8067((class_1799)stack);
        for (class_1293 effectInstance : mobEffectInstances) {
            player.method_6092(new class_1293(effectInstance.method_5579(), Math.max(effectInstance.method_5584() / 8, 1), effectInstance.method_5578(), effectInstance.method_5591(), effectInstance.method_5592()));
        }
    }

    public static void potionBrew(class_2586 brewingStandTileEntity, class_1799 ingredient) {
        ((BrewingStandDuck)brewingStandTileEntity).addXp(Util.getBrewXp(ingredient));
    }

    public static void heldItemChangeEvent(class_1657 player) {
        class_1799 stack = player.method_6047();
        if (stack.method_7909() instanceof class_1803 || stack.method_7909() instanceof class_1828) {
            player.method_7357().method_7906(class_1802.field_8436, Services.PLATFORM.potionSwitchCooldown());
            player.method_7357().method_7906(class_1802.field_8150, Services.PLATFORM.potionSwitchCooldown());
        }
    }

    public static void playerTakeBrewedPotion(class_1657 player) {
        if (!player.method_37908().field_9236) {
            class_1703 container = player.field_7512;
            Object entity = null;
            if (container instanceof class_1708) {
                entity = (class_2589)((BrewingStandContainerAccess)container).getBrewingStand();
            } else if (container instanceof CAdvancedBrewingStandMenu) {
                entity = ((CAdvancedBrewingStandMenu)container).blockEntity;
            }
            if (entity != null) {
                ((BrewingStandDuck)entity).dump(player);
            }
        }
    }

    public static boolean canApplyEffect(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return !(player.method_6030().method_7909() instanceof CUmbrellaItem);
        }
        return true;
    }

    public static void afterHit(class_1657 player, class_1309 victim) {
        class_1799 weapon = player.method_6047();
        if (DavesPotioneering.isCoatable(weapon)) {
            List potion = class_1844.method_8067((class_1799)weapon);
            for (class_1293 effectinstance : potion) {
                victim.method_6092(new class_1293(effectinstance.method_5579(), Math.max(effectinstance.method_5584() / 8, 1), effectinstance.method_5578(), effectinstance.method_5591(), effectinstance.method_5581()));
            }
            if (!player.method_31549().field_7477) {
                CLayeredReinforcedCauldronBlock.useCharge(weapon);
            }
        }
    }

    public static boolean isCoatable(class_1799 stack) {
        return stack.method_31573(ModItems.WHITELISTED) && !stack.method_31573(ModItems.BLACKLISTED);
    }

    public static void tagsUpdated() {
        long start = class_156.method_648();
        ModCauldronInteractions.reload();
        long end = class_156.method_648();
        long time = end - start;
        float ms = (float)time / 1000000.0f;
        DecimalFormat df = new DecimalFormat("#.####");
        df.setRoundingMode(RoundingMode.DOWN);
        String s = df.format(ms);
        LOG.info("Took " + s + " ms to reload cauldron interactions");
    }
}

